/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InputStreamTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new InputStreamHandler();
    }

    @Test
    public void testInvalidInputStream() throws IOException, ExecutionException, InterruptedException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            HttpHeaders h = new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            InputStream is = new InputStream(){
                int readAllowed;

                @Override
                public int available() {
                    return 1;
                }

                @Override
                public int read() {
                    int fakeCount;
                    if ((fakeCount = this.readAllowed++) == 0) {
                        return 97;
                    }
                    if (fakeCount == 1) {
                        return 98;
                    }
                    if (fakeCount == 2) {
                        return 99;
                    }
                    return -1;
                }
            };
            Response resp = (Response)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeaders(h)).setBody(is)).execute().get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader((CharSequence)"X-Param"), (String)"abc");
        }
    }

    private static class InputStreamHandler
    extends AbstractHandler {
        private InputStreamHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("POST".equalsIgnoreCase(request.getMethod())) {
                byte[] bytes = new byte[3];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int read = 0;
                while (read > -1) {
                    read = request.getInputStream().read(bytes);
                    if (read <= 0) continue;
                    bos.write(bytes, 0, read);
                }
                response.setStatus(200);
                response.addHeader("X-Param", new String(bos.toByteArray()));
            } else {
                response.sendError(403);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

