/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.reactivestreams;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelFutureListener;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelProgressiveFuture;
import org.apache.hive.druid.io.netty.channel.ChannelProgressiveFutureListener;
import org.apache.hive.druid.io.netty.channel.ChannelPromise;
import org.apache.hive.druid.io.netty.channel.DefaultFileRegion;
import org.apache.hive.druid.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.hive.druid.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpChunkedInput;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpMessage;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpUtil;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpVersion;
import org.apache.hive.druid.io.netty.handler.codec.http.LastHttpContent;
import org.apache.hive.druid.io.netty.handler.ssl.SslHandler;
import org.apache.hive.druid.io.netty.handler.stream.ChunkedFile;
import org.apache.hive.druid.io.netty.handler.stream.ChunkedInput;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.apache.hive.druid.io.netty.util.concurrent.GenericFutureListener;
import org.asynchttpclient.test.TestUtils;

public class HttpStaticFileServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    private static final int HTTP_CACHE_SECONDS = 60;
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[A-Za-z0-9][-_A-Za-z0-9.]*");

    private static String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        if (uri.isEmpty() || uri.charAt(0) != '/') {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return TestUtils.TMP_DIR + File.separator + uri;
    }

    private static void sendListing(ChannelHandlerContext ctx, File dir) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        String dirPath = dir.getPath();
        StringBuilder buf = new StringBuilder().append("<!DOCTYPE html>\r\n").append("<html><head><title>").append("Listing of: ").append(dirPath).append("</title></head><body>\r\n").append("<h3>Listing of: ").append(dirPath).append("</h3>\r\n").append("<ul>").append("<li><a href=\"../\">..</a></li>\r\n");
        for (File f : dir.listFiles()) {
            String name;
            if (f.isHidden() || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
            buf.append("<li><a href=\"").append(name).append("\">").append(name).append("</a></li>\r\n");
        }
        buf.append("</ul></body></html>\r\n");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8);
        response.content().writeBytes(buffer);
        buffer.release();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        HttpStaticFileServerHandler.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.getTime()));
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=60");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mimeTypesMap.getContentType(file.getPath()));
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        ChannelFuture lastContentFuture;
        ChannelFuture sendFileFuture;
        RandomAccessFile raf;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        if (!request.decoderResult().isSuccess()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (request.method() != HttpMethod.GET) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String uri = request.uri();
        String path = HttpStaticFileServerHandler.sanitizeUri(uri);
        if (path == null) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (file.isDirectory()) {
            if (uri.endsWith("/")) {
                HttpStaticFileServerHandler.sendListing(ctx, file);
            } else {
                HttpStaticFileServerHandler.sendRedirect(ctx, uri + '/');
            }
            return;
        }
        if (!file.isFile()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        String ifModifiedSince = request.headers().get((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            HttpStaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ignore) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
        HttpStaticFileServerHandler.setContentTypeHeader((HttpResponse)response, file);
        HttpStaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        if (ctx.pipeline().get(SslHandler.class) == null) {
            sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
            lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
        }
        sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                if (total < 0L) {
                    System.err.println(future.channel() + " Transfer progress: " + progress);
                } else {
                    System.err.println(future.channel() + " Transfer progress: " + progress + " / " + total);
                }
            }

            public void operationComplete(ChannelProgressiveFuture future) {
                System.err.println(future.channel() + " Transfer complete.");
            }
        });
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

