/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NettyRequestThrottleTimeoutTest
extends AbstractBasicTest {
    private static final String MSG = "Enough is enough.";
    private static final int SLEEPTIME_MS = 1000;

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowHandler();
    }

    @Test
    public void testRequestTimeout() throws IOException {
        final Semaphore requestThrottle = new Semaphore(1);
        int samples = 10;
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setMaxConnections(1));){
            CountDownLatch latch = new CountDownLatch(samples);
            List<Exception> tooManyConnections = Collections.synchronizedList(new ArrayList(2));
            for (int i = 0; i < samples; ++i) {
                new Thread(() -> {
                    try {
                        requestThrottle.acquire();
                        Future responseFuture = null;
                        try {
                            responseFuture = ((BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRequestTimeout(500)).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                                public Response onCompleted(Response response) {
                                    return response;
                                }

                                public void onThrowable(Throwable t) {
                                    NettyRequestThrottleTimeoutTest.this.logger.error("onThrowable got an error", t);
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    requestThrottle.release();
                                }
                            });
                        }
                        catch (Exception e) {
                            tooManyConnections.add(e);
                        }
                        if (responseFuture != null) {
                            responseFuture.get();
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        latch.countDown();
                    }
                }).start();
            }
            try {
                latch.await(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Assert.fail((String)"failed to wait for requests to complete");
            }
            for (Exception e : tooManyConnections) {
                this.logger.error("Exception while calling execute", (Throwable)e);
            }
            Assert.assertTrue((boolean)tooManyConnections.isEmpty(), (String)"Should not have any connection errors where too many connections have been attempted");
        }
    }

    private class SlowHandler
    extends AbstractHandler {
        private SlowHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setStatus(200);
            AsyncContext asyncContext = request.startAsync();
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    response.getOutputStream().print(NettyRequestThrottleTimeoutTest.MSG);
                    response.getOutputStream().flush();
                    asyncContext.complete();
                }
                catch (IOException | InterruptedException e) {
                    NettyRequestThrottleTimeoutTest.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }).start();
            baseRequest.setHandled(true);
        }
    }
}

