/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.Cookie;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.netty.NettyResponse;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NettyAsyncResponseTest {
    @Test
    public void testCookieParseExpires() {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = new Date(System.currentTimeMillis() + 60000L);
        String cookieDef = String.format("efmembercheck=true; expires=%s; path=/; domain=.eclipse.org", sdf.format(date));
        HttpHeaders responseHeaders = new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookieDef);
        NettyResponse response = new NettyResponse((HttpResponseStatus)new NettyResponseStatus(null, null, null), responseHeaders, null);
        List cookies = response.getCookies();
        Assert.assertEquals((int)cookies.size(), (int)1);
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertTrue((cookie.maxAge() >= 58L && cookie.maxAge() <= 60L ? 1 : 0) != 0);
    }

    @Test
    public void testCookieParseMaxAge() {
        String cookieDef = "efmembercheck=true; max-age=60; path=/; domain=.eclipse.org";
        HttpHeaders responseHeaders = new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"efmembercheck=true; max-age=60; path=/; domain=.eclipse.org");
        NettyResponse response = new NettyResponse((HttpResponseStatus)new NettyResponseStatus(null, null, null), responseHeaders, null);
        List cookies = response.getCookies();
        Assert.assertEquals((int)cookies.size(), (int)1);
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((long)cookie.maxAge(), (long)60L);
    }

    @Test
    public void testCookieParseWeirdExpiresValue() {
        String cookieDef = "efmembercheck=true; expires=60; path=/; domain=.eclipse.org";
        HttpHeaders responseHeaders = new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"efmembercheck=true; expires=60; path=/; domain=.eclipse.org");
        NettyResponse response = new NettyResponse((HttpResponseStatus)new NettyResponseStatus(null, null, null), responseHeaders, null);
        List cookies = response.getCookies();
        Assert.assertEquals((int)cookies.size(), (int)1);
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((long)cookie.maxAge(), (long)Long.MIN_VALUE);
    }
}

