/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderValues;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.exception.RemotelyClosedException;
import org.asynchttpclient.handler.BodyDeferringAsyncHandler;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BodyDeferringAsyncHandlerTest
extends AbstractBasicTest {
    static final int CONTENT_LENGTH_VALUE = 100000;

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowAndBigHandler();
    }

    private AsyncHttpClientConfig getAsyncHttpClientConfig() {
        return Dsl.config().setMaxRequestRetry(0).setRequestTimeout(10000).build();
    }

    @Test
    public void deferredSimple() throws IOException, ExecutionException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.getAsyncHttpClientConfig());){
            BoundRequestBuilder r = client.prepareGet(this.getTargetUrl());
            CountingOutputStream cos = new CountingOutputStream();
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)cos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            Response resp = bdah.getResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (String)String.valueOf(100000));
            Assert.assertTrue((cos.getByteCount() <= 100000 ? 1 : 0) != 0);
            f.get();
            Assert.assertEquals((int)cos.getByteCount(), (int)100000);
        }
    }

    @Test(expectedExceptions={RemotelyClosedException.class}, enabled=false)
    public void deferredSimpleWithFailure() throws Throwable {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.getAsyncHttpClientConfig());){
            BoundRequestBuilder r = (BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).addHeader((CharSequence)"X-FAIL-TRANSFER", Boolean.TRUE.toString());
            CountingOutputStream cos = new CountingOutputStream();
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)cos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            Response resp = bdah.getResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (String)String.valueOf(100000));
            Assert.assertTrue((cos.getByteCount() <= 100000 ? 1 : 0) != 0);
            try {
                f.get();
            }
            catch (ExecutionException e) {
                Assert.assertNotEquals((Object)cos.getByteCount(), (Object)100000);
                throw e.getCause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deferredInputStreamTrick() throws IOException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.getAsyncHttpClientConfig());){
            BoundRequestBuilder r = client.prepareGet(this.getTargetUrl());
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)pos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            BodyDeferringAsyncHandler.BodyDeferringInputStream is = new BodyDeferringAsyncHandler.BodyDeferringInputStream((Future)f, bdah, (InputStream)pis);
            Response resp = is.getAsapResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (String)String.valueOf(100000));
            CountingOutputStream cos = new CountingOutputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)cos);
            }
            finally {
                is.close();
                cos.close();
            }
            Assert.assertEquals((int)cos.getByteCount(), (int)100000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={RemotelyClosedException.class})
    public void deferredInputStreamTrickWithFailure() throws Throwable {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.getAsyncHttpClientConfig());){
            BoundRequestBuilder r = (BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).addHeader((CharSequence)"X-FAIL-TRANSFER", Boolean.TRUE.toString());
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)pos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            BodyDeferringAsyncHandler.BodyDeferringInputStream is = new BodyDeferringAsyncHandler.BodyDeferringInputStream((Future)f, bdah, (InputStream)pis);
            Response resp = is.getAsapResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (String)String.valueOf(100000));
            CountingOutputStream cos = new CountingOutputStream();
            try {
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)cos);
                }
                finally {
                    is.close();
                    cos.close();
                }
            }
            catch (IOException e) {
                throw e.getCause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void deferredInputStreamTrickWithCloseConnectionAndRetry() throws Throwable {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)Dsl.config().setMaxRequestRetry(1).setRequestTimeout(10000).build());){
            BoundRequestBuilder r = (BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).addHeader((CharSequence)"X-CLOSE-CONNECTION", Boolean.TRUE.toString());
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)pos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            BodyDeferringAsyncHandler.BodyDeferringInputStream is = new BodyDeferringAsyncHandler.BodyDeferringInputStream((Future)f, bdah, (InputStream)pis);
            Response resp = is.getAsapResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (String)String.valueOf(100000));
            CountingOutputStream cos = new CountingOutputStream();
            try {
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)cos);
                }
                finally {
                    is.close();
                    cos.close();
                }
            }
            catch (IOException e) {
                throw e.getCause();
            }
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectionRefused() throws IOException, InterruptedException {
        int newPortWithoutAnyoneListening = TestUtils.findFreePort();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.getAsyncHttpClientConfig());){
            BoundRequestBuilder r = client.prepareGet("http://localhost:" + newPortWithoutAnyoneListening + "/testConnectionRefused");
            CountingOutputStream cos = new CountingOutputStream();
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)cos);
            r.execute((AsyncHandler)bdah);
            bdah.getResponse();
        }
    }

    @Test
    public void testPipedStreams() throws Exception {
        block37: {
            try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.getAsyncHttpClientConfig());){
                PipedOutputStream pout = new PipedOutputStream();
                try (PipedInputStream pin = new PipedInputStream(pout);){
                    BodyDeferringAsyncHandler handler = new BodyDeferringAsyncHandler((OutputStream)pout);
                    ListenableFuture respFut = client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler);
                    Response resp = handler.getResponse();
                    if (resp.getStatusCode() == 200) {
                        try (BodyDeferringAsyncHandler.BodyDeferringInputStream is = new BodyDeferringAsyncHandler.BodyDeferringInputStream((Future)respFut, handler, (InputStream)pin);){
                            String body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                            Assert.assertTrue((boolean)body.contains("ABCDEF"));
                            break block37;
                        }
                    }
                    throw new IOException("HTTP error " + resp.getStatusCode());
                }
            }
        }
    }

    public static class CountingOutputStream
    extends OutputStream {
        private int byteCount = 0;

        @Override
        public void write(int b) {
            ++this.byteCount;
        }

        int getByteCount() {
            return this.byteCount;
        }
    }

    public static class SlowAndBigHandler
    extends AbstractHandler {
        public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setStatus(200);
            httpResponse.setContentLength(100000);
            httpResponse.setContentType(HttpHeaderValues.APPLICATION_OCTET_STREAM.toString());
            httpResponse.flushBuffer();
            boolean wantConnectionClose = httpRequest.getHeader("X-CLOSE-CONNECTION") != null;
            boolean wantFailure = httpRequest.getHeader("X-FAIL-TRANSFER") != null;
            boolean wantSlow = httpRequest.getHeader("X-SLOW") != null;
            ServletOutputStream os = httpResponse.getOutputStream();
            for (int i = 0; i < 100000; ++i) {
                os.write(i % 255);
                if (wantSlow) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (i <= 50000) continue;
                if (wantFailure) {
                    httpResponse.sendError(500);
                    break;
                }
                if (!wantConnectionClose) continue;
                httpResponse.getOutputStream().close();
            }
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

