/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.exception.TooManyConnectionsException;
import org.asynchttpclient.test.EventCollectingHandler;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConnectionPoolTest
extends AbstractBasicTest {
    @Test
    public void testMaxTotalConnections() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setKeepAlive(true).setMaxConnections(1));){
            String url = this.getTargetUrl();
            Exception exception = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    this.logger.info("{} requesting url [{}]...", (Object)i, (Object)url);
                    Response response = (Response)client.prepareGet(url).execute().get();
                    this.logger.info("{} response [{}].", (Object)i, (Object)response);
                    continue;
                }
                catch (Exception ex) {
                    exception = ex;
                }
            }
            Assert.assertNull(exception);
        }
    }

    @Test(expectedExceptions={TooManyConnectionsException.class})
    public void testMaxTotalConnectionsException() throws Throwable {
        AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setKeepAlive(true).setMaxConnections(1));
        Throwable throwable = null;
        try {
            try {
                String url = this.getTargetUrl();
                ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                for (int i = 0; i < 5; ++i) {
                    this.logger.info("{} requesting url [{}]...", (Object)i, (Object)url);
                    futures.add(client.prepareGet(url).execute());
                }
                Throwable exception = null;
                for (ListenableFuture future : futures) {
                    try {
                        future.get();
                    }
                    catch (Exception ex) {
                        exception = ex;
                        break;
                    }
                }
                Assert.assertNotNull(exception);
                throw exception.getCause();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (client != null) {
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    client.close();
                }
            }
            throw throwable3;
        }
    }

    @Test(invocationCount=100)
    public void asyncDoGetKeepAliveHandlerTest_channelClosedDoesNotFail() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            final CountDownLatch l = new CountDownLatch(2);
            final ConcurrentHashMap remoteAddresses = new ConcurrentHashMap();
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    ConnectionPoolTest.this.logger.debug("ON COMPLETED INVOKED " + response.getHeader((CharSequence)"X-KEEP-ALIVE"));
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)200);
                        remoteAddresses.put(response.getHeader((CharSequence)"X-KEEP-ALIVE"), true);
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        super.onThrowable(t);
                    }
                    finally {
                        l.countDown();
                    }
                }
            };
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler).get();
            this.server.stop();
            this.server = new Server();
            ServerConnector newConnector = TestUtils.addHttpConnector(this.server);
            newConnector.setPort(this.port1);
            this.server.setHandler((Handler)this.configureHandler());
            this.server.start();
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler);
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
            Assert.assertEquals((int)remoteAddresses.size(), (int)2);
        }
    }

    @Test(expectedExceptions={TooManyConnectionsException.class})
    public void multipleMaxConnectionOpenTest() throws Throwable {
        AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setKeepAlive(true).setConnectTimeout(5000).setMaxConnections(1));
        Throwable throwable = null;
        try {
            try {
                String body = "hello there";
                Response response = (Response)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setBody(body)).execute().get(30L, TimeUnit.SECONDS);
                Assert.assertEquals((String)response.getResponseBody(), (String)body);
                Exception exception = null;
                try {
                    ((BoundRequestBuilder)c.preparePost(String.format("http://localhost:%d/foo/test", this.port2)).setBody(body)).execute().get(30L, TimeUnit.SECONDS);
                    Assert.fail((String)"Should throw exception. Too many connections issued.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    exception = ex;
                }
                Assert.assertNotNull((Object)exception);
                throw exception.getCause();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (c != null) {
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    c.close();
                }
            }
            throw throwable3;
        }
    }

    @Test
    public void multipleMaxConnectionOpenTestWithQuery() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setKeepAlive(true).setConnectTimeout(5000).setMaxConnections(1));){
            String body = "hello there";
            Response response = (Response)((BoundRequestBuilder)c.preparePost(this.getTargetUrl() + "?foo=bar").setBody(body)).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)("foo_" + body));
            Exception exception = null;
            try {
                response = (Response)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setBody(body)).execute().get(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                exception = ex;
            }
            Assert.assertNull((Object)exception);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test
    public void win7DisconnectTest() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    count.incrementAndGet();
                    StackTraceElement e = new StackTraceElement("sun.nio.ch.SocketDispatcher", "read0", null, -1);
                    IOException t = new IOException();
                    t.setStackTrace(new StackTraceElement[]{e});
                    throw t;
                }
            };
            try {
                client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler).get();
                Assert.fail((String)"Must have received an exception");
            }
            catch (ExecutionException ex) {
                Assert.assertNotNull((Object)ex);
                Assert.assertNotNull((Object)ex.getCause());
                Assert.assertEquals(ex.getCause().getClass(), IOException.class);
                Assert.assertEquals((int)count.get(), (int)1);
            }
        }
    }

    @Test
    public void asyncHandlerOnThrowableTest() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            final AtomicInteger count = new AtomicInteger();
            String THIS_IS_NOT_FOR_YOU = "This is not for you";
            final CountDownLatch latch = new CountDownLatch(16);
            for (int i = 0; i < 16; ++i) {
                client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public Response onCompleted(Response response) throws Exception {
                        throw new Exception("This is not for you");
                    }
                });
                client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public void onThrowable(Throwable t) {
                        if (t.getMessage() != null && t.getMessage().equalsIgnoreCase("This is not for you")) {
                            count.incrementAndGet();
                        }
                    }

                    public Response onCompleted(Response response) {
                        latch.countDown();
                        return response;
                    }
                });
            }
            latch.await(30L, TimeUnit.SECONDS);
            Assert.assertEquals((int)count.get(), (int)0);
        }
    }

    @Test
    public void nonPoolableConnectionReleaseSemaphoresTest() throws Throwable {
        RequestBuilder request = (RequestBuilder)Dsl.get((String)this.getTargetUrl()).setHeader((CharSequence)"Connection", "close");
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setMaxConnections(6).setMaxConnectionsPerHost(3));){
            client.executeRequest(request).get();
            Thread.sleep(1000L);
            client.executeRequest(request).get();
            Thread.sleep(1000L);
            client.executeRequest(request).get();
            Thread.sleep(1000L);
            client.executeRequest(request).get();
        }
    }

    @Test
    public void testPooledEventsFired() throws Exception {
        RequestBuilder request = Dsl.get((String)("http://localhost:" + this.port1 + "/Test"));
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            EventCollectingHandler firstHandler = new EventCollectingHandler();
            client.executeRequest(request, (AsyncHandler)firstHandler).get(3L, TimeUnit.SECONDS);
            firstHandler.waitForCompletion(3, TimeUnit.SECONDS);
            EventCollectingHandler secondHandler = new EventCollectingHandler();
            client.executeRequest(request, (AsyncHandler)secondHandler).get(3L, TimeUnit.SECONDS);
            secondHandler.waitForCompletion(3, TimeUnit.SECONDS);
            Object[] expectedEvents = new Object[]{"ConnectionPool", "ConnectionPooled", "RequestSend", "HeadersWritten", "StatusReceived", "HeadersReceived", "ConnectionOffer", "Completed"};
            Assert.assertEquals((Object[])secondHandler.firedEvents.toArray(), (Object[])expectedEvents, (String)("Got " + Arrays.toString(secondHandler.firedEvents.toArray())));
        }
    }
}

