/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RedirectBodyTest
extends AbstractBasicTest {
    private volatile boolean redirectAlreadyPerformed;
    private volatile String receivedContentType;

    @BeforeMethod
    public void setUp() {
        this.redirectAlreadyPerformed = false;
        this.receivedContentType = null;
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
                String redirectHeader = httpRequest.getHeader("X-REDIRECT");
                if (redirectHeader != null && !RedirectBodyTest.this.redirectAlreadyPerformed) {
                    RedirectBodyTest.this.redirectAlreadyPerformed = true;
                    httpResponse.setStatus(Integer.valueOf(redirectHeader).intValue());
                    httpResponse.setContentLength(0);
                    httpResponse.setHeader(HttpHeaderNames.LOCATION.toString(), RedirectBodyTest.this.getTargetUrl());
                } else {
                    RedirectBodyTest.this.receivedContentType = request.getContentType();
                    httpResponse.setStatus(200);
                    int len = request.getContentLength();
                    httpResponse.setContentLength(len);
                    if (len > 0) {
                        byte[] buffer = new byte[len];
                        IOUtils.read((InputStream)request.getInputStream(), (byte[])buffer);
                        httpResponse.getOutputStream().write(buffer);
                    }
                }
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
            }
        };
    }

    @Test
    public void regular301LosesBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            String body = "hello there";
            String contentType = "text/plain; charset=UTF-8";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "301")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)"");
            Assert.assertNull((Object)this.receivedContentType);
        }
    }

    @Test
    public void regular302LosesBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            String body = "hello there";
            String contentType = "text/plain; charset=UTF-8";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "302")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)"");
            Assert.assertNull((Object)this.receivedContentType);
        }
    }

    @Test
    public void regular302StrictKeepsBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).setStrict302Handling(true));){
            String body = "hello there";
            String contentType = "text/plain; charset=UTF-8";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "302")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            Assert.assertEquals((String)this.receivedContentType, (String)contentType);
        }
    }

    @Test
    public void regular307KeepsBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            String body = "hello there";
            String contentType = "text/plain; charset=UTF-8";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "307")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            Assert.assertEquals((String)this.receivedContentType, (String)contentType);
        }
    }
}

