/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.ResponseFilter;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PostRedirectGetTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new PostRedirectGetHandler();
    }

    @Test
    public void postRedirectGet302Test() throws Exception {
        this.doTestPositive(302);
    }

    @Test
    public void postRedirectGet302StrictTest() throws Exception {
        this.doTestNegative(302, true);
    }

    @Test
    public void postRedirectGet303Test() throws Exception {
        this.doTestPositive(303);
    }

    @Test
    public void postRedirectGet301Test() throws Exception {
        this.doTestPositive(301);
    }

    @Test
    public void postRedirectGet307Test() throws Exception {
        this.doTestNegative(307, false);
    }

    private void doTestNegative(int status, boolean strict) throws Exception {
        ResponseFilter responseFilter = new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) {
                ctx.getResponseHeaders().get("x-expect-post");
                ctx.getRequest().getHeaders().add("x-expect-post", (Object)"true");
                ctx.getRequest().getHeaders().remove("x-redirect");
                return ctx;
            }
        };
        try (AsyncHttpClient p = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).setStrict302Handling(strict).addResponseFilter(responseFilter));){
            Request request = ((RequestBuilder)((RequestBuilder)((RequestBuilder)Dsl.post((String)this.getTargetUrl()).addFormParam("q", "a b")).addHeader((CharSequence)"x-redirect", status + "@http://localhost:" + this.port1 + "/foo/bar/baz")).addHeader((CharSequence)"x-negative", "true")).build();
            ListenableFuture responseFuture = p.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Integer>(){

                public Integer onCompleted(Response response) {
                    return response.getStatusCode();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            int statusCode = (Integer)responseFuture.get();
            Assert.assertEquals((int)statusCode, (int)200);
        }
    }

    private void doTestPositive(int status) throws Exception {
        ResponseFilter responseFilter = new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) {
                ctx.getResponseHeaders().get("x-expect-get");
                ctx.getRequest().getHeaders().add("x-expect-get", (Object)"true");
                ctx.getRequest().getHeaders().remove("x-redirect");
                return ctx;
            }
        };
        try (AsyncHttpClient p = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).addResponseFilter(responseFilter));){
            Request request = ((RequestBuilder)((RequestBuilder)Dsl.post((String)this.getTargetUrl()).addFormParam("q", "a b")).addHeader((CharSequence)"x-redirect", status + "@http://localhost:" + this.port1 + "/foo/bar/baz")).build();
            ListenableFuture responseFuture = p.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Integer>(){

                public Integer onCompleted(Response response) {
                    return response.getStatusCode();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            int statusCode = (Integer)responseFuture.get();
            Assert.assertEquals((int)statusCode, (int)200);
        }
    }

    public static class PostRedirectGetHandler
    extends AbstractHandler {
        final AtomicInteger counter = new AtomicInteger();

        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            boolean expectPost;
            boolean expectGet = httpRequest.getHeader("x-expect-get") != null;
            boolean bl = expectPost = httpRequest.getHeader("x-expect-post") != null;
            if (expectGet) {
                String method = request.getMethod();
                if (!"GET".equals(method)) {
                    httpResponse.sendError(500, "Incorrect method.  Expected GET, received " + method);
                    return;
                }
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write("OK".getBytes());
                httpResponse.getOutputStream().flush();
                return;
            }
            if (expectPost) {
                String method = request.getMethod();
                if (!"POST".equals(method)) {
                    httpResponse.sendError(500, "Incorrect method.  Expected POST, received " + method);
                    return;
                }
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write("OK".getBytes());
                httpResponse.getOutputStream().flush();
                return;
            }
            String header = httpRequest.getHeader("x-redirect");
            if (header != null) {
                int redirectCode;
                String[] parts = header.split("@");
                try {
                    redirectCode = Integer.parseInt(parts[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    httpResponse.sendError(500, "Unable to parse redirect code");
                    return;
                }
                httpResponse.setStatus(redirectCode);
                if (httpRequest.getHeader("x-negative") == null) {
                    httpResponse.addHeader("x-expect-get", "true");
                } else {
                    httpResponse.addHeader("x-expect-post", "true");
                }
                httpResponse.setContentLength(0);
                httpResponse.addHeader("Location", parts[1] + this.counter.getAndIncrement());
                httpResponse.getOutputStream().flush();
                return;
            }
            httpResponse.sendError(500);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

