/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ListenableFutureTest
extends AbstractBasicTest {
    @Test
    public void testListenableFuture() throws Exception {
        AtomicInteger statusCode = new AtomicInteger(500);
        try (AsyncHttpClient ahc = Dsl.asyncHttpClient();){
            CountDownLatch latch = new CountDownLatch(1);
            ListenableFuture future = ahc.prepareGet(this.getTargetUrl()).execute();
            future.addListener(() -> {
                try {
                    statusCode.set(((Response)future.get()).getStatusCode());
                    latch.countDown();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }, (Executor)Executors.newFixedThreadPool(1));
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((int)statusCode.get(), (int)200);
        }
    }

    @Test
    public void testListenableFutureAfterCompletion() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        try (AsyncHttpClient ahc = Dsl.asyncHttpClient();){
            ListenableFuture future = ahc.prepareGet(this.getTargetUrl()).execute();
            future.get();
            future.addListener(latch::countDown, Runnable::run);
        }
        latch.await(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testListenableFutureBeforeAndAfterCompletion() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        try (AsyncHttpClient ahc = Dsl.asyncHttpClient();){
            ListenableFuture future = ahc.prepareGet(this.getTargetUrl()).execute();
            future.addListener(latch::countDown, Runnable::run);
            future.get();
            future.addListener(latch::countDown, Runnable::run);
        }
        latch.await(10L, TimeUnit.SECONDS);
    }
}

