/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DigestAuthTest
extends AbstractBasicTest {
    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        TestUtils.addDigestAuthHandler(this.server, (Handler)this.configureHandler());
        this.server.start();
        this.port1 = connector.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SimpleHandler();
    }

    @Test
    public void digestAuthTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet("http://localhost:" + this.port1 + "/").setRealm(Dsl.digestAuthRealm((String)"user", (String)"admin").setRealmName("MyRealm").build())).execute();
            Response resp = (Response)f.get(60L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
        }
    }

    @Test
    public void digestAuthTestWithoutScheme() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet("http://localhost:" + this.port1 + "/").setRealm(Dsl.digestAuthRealm((String)"user", (String)"admin").setRealmName("MyRealm").build())).execute();
            Response resp = (Response)f.get(60L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
        }
    }

    @Test
    public void digestAuthNegativeTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet("http://localhost:" + this.port1 + "/").setRealm(Dsl.digestAuthRealm((String)"fake", (String)"admin").build())).execute();
            Response resp = (Response)f.get(20L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)401);
        }
    }

    private static class SimpleHandler
    extends AbstractHandler {
        private SimpleHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.addHeader("X-Auth", request.getHeader("Authorization"));
            response.setStatus(200);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

