/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.util.List;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.Cookie;
import org.asynchttpclient.cookie.ThreadSafeCookieStore;
import org.asynchttpclient.uri.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CookieStoreTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() {
        this.logger.info("Local HTTP server started successfully");
        System.out.println("--Start");
    }

    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() {
        System.out.println("--Stop");
    }

    @Test
    public void runAllSequentiallyBecauseNotThreadSafe() {
        this.addCookieWithEmptyPath();
        this.dontReturnCookieForAnotherDomain();
        this.returnCookieWhenItWasSetOnSamePath();
        this.returnCookieWhenItWasSetOnParentPath();
        this.dontReturnCookieWhenDomainMatchesButPathIsDifferent();
        this.dontReturnCookieWhenDomainMatchesButPathIsParent();
        this.returnCookieWhenDomainMatchesAndPathIsChild();
        this.returnCookieWhenItWasSetOnSubdomain();
        this.replaceCookieWhenSetOnSameDomainAndPath();
        this.dontReplaceCookiesWhenTheyHaveDifferentName();
        this.expireCookieWhenSetWithDateInThePast();
        this.cookieWithSameNameMustCoexistIfSetOnDifferentDomains();
        this.handleMissingDomainAsRequestHost();
        this.handleMissingPathAsSlash();
        this.returnTheCookieWheniTSissuedFromRequestWithSubpath();
        this.handleMissingPathAsRequestPathWhenFromRootDir();
        this.handleMissingPathAsRequestPathWhenPathIsNotEmpty();
        this.handleDomainInCaseInsensitiveManner();
        this.handleCookieNameInCaseInsensitiveManner();
        this.handleCookiePathInCaseSensitiveManner();
        this.ignoreQueryParametersInUri();
        this.shouldServerOnSubdomainWhenDomainMatches();
        this.replaceCookieWhenSetOnSamePathBySameUri();
        this.handleMultipleCookieOfSameNameOnDifferentPaths();
        this.handleTrailingSlashesInPaths();
        this.returnMultipleCookiesEvenIfTheyHaveSameName();
        this.shouldServeCookiesBasedOnTheUriScheme();
        this.shouldAlsoServeNonSecureCookiesBasedOnTheUriScheme();
        this.shouldNotServeSecureCookiesForDefaultRetrievedHttpUriScheme();
        this.shouldServeSecureCookiesForSpecificallyRetrievedHttpUriScheme();
    }

    private void addCookieWithEmptyPath() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com");
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; path="));
        Assert.assertTrue((store.get(uri).size() > 0 ? 1 : 0) != 0);
    }

    private void dontReturnCookieForAnotherDomain() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; path="));
        Assert.assertTrue((boolean)store.get(Uri.create((String)"http://www.bar.com")).isEmpty());
    }

    private void returnCookieWhenItWasSetOnSamePath() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; path=/bar/"));
        Assert.assertTrue((store.get(Uri.create((String)"http://www.foo.com/bar/")).size() == 1 ? 1 : 0) != 0);
    }

    private void returnCookieWhenItWasSetOnParentPath() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((store.get(Uri.create((String)"http://www.foo.com/bar/baz")).size() == 1 ? 1 : 0) != 0);
    }

    private void dontReturnCookieWhenDomainMatchesButPathIsDifferent() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/bar"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((boolean)store.get(Uri.create((String)"http://www.foo.com/baz")).isEmpty());
    }

    private void dontReturnCookieWhenDomainMatchesButPathIsParent() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/bar"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((boolean)store.get(Uri.create((String)"http://www.foo.com")).isEmpty());
    }

    private void returnCookieWhenDomainMatchesAndPathIsChild() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/bar"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((store.get(Uri.create((String)"http://www.foo.com/bar/baz")).size() == 1 ? 1 : 0) != 0);
    }

    private void returnCookieWhenItWasSetOnSubdomain() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=.foo.com"));
        Assert.assertTrue((store.get(Uri.create((String)"http://bar.foo.com")).size() == 1 ? 1 : 0) != 0);
    }

    private void replaceCookieWhenSetOnSameDomainAndPath() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com/bar/baz");
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE2; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((store.getAll().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).value().equals("VALUE2"));
    }

    private void dontReplaceCookiesWhenTheyHaveDifferentName() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com/bar/baz");
        store.add(uri, ClientCookieDecoder.LAX.decode("BETA=VALUE1; Domain=www.foo.com; path=/bar"));
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE2; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((store.get(uri).size() == 2 ? 1 : 0) != 0);
    }

    private void expireCookieWhenSetWithDateInThePast() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com/bar");
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=EXPIRED; Domain=www.foo.com; Path=/bar; Expires=Sun, 06 Nov 1994 08:49:37 GMT"));
        Assert.assertTrue((boolean)store.getAll().isEmpty());
    }

    private void cookieWithSameNameMustCoexistIfSetOnDifferentDomains() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri1 = Uri.create((String)"http://www.foo.com");
        store.add(uri1, ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com"));
        Uri uri2 = Uri.create((String)"http://www.bar.com");
        store.add(uri2, ClientCookieDecoder.LAX.decode("ALPHA=VALUE2; Domain=www.bar.com"));
        Assert.assertTrue((store.get(uri1).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri1).get(0)).value().equals("VALUE1"));
        Assert.assertTrue((store.get(uri2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri2).get(0)).value().equals("VALUE2"));
    }

    private void handleMissingDomainAsRequestHost() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com");
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Path=/"));
        Assert.assertTrue((store.get(uri).size() == 1 ? 1 : 0) != 0);
    }

    private void handleMissingPathAsSlash() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com");
        store.add(uri, ClientCookieDecoder.LAX.decode("tooe_token=0b1d81dd02d207491a6e9b0a2af9470da9eb1dad"));
        Assert.assertTrue((store.get(uri).size() == 1 ? 1 : 0) != 0);
    }

    private void returnTheCookieWheniTSissuedFromRequestWithSubpath() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/bar"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE; path=/"));
        Assert.assertTrue((store.get(Uri.create((String)"http://www.foo.com")).size() == 1 ? 1 : 0) != 0);
    }

    private void handleMissingPathAsRequestPathWhenFromRootDir() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com");
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE1"));
        Assert.assertTrue((store.get(uri).size() == 1 ? 1 : 0) != 0);
    }

    private void handleMissingPathAsRequestPathWhenPathIsNotEmpty() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/bar"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((boolean)store.get(Uri.create((String)"http://www.foo.com/baz")).isEmpty());
    }

    private void handleDomainInCaseInsensitiveManner() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/bar"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1"));
        Assert.assertTrue((store.get(Uri.create((String)"http://www.FoO.com/bar")).size() == 1 ? 1 : 0) != 0);
    }

    private void handleCookieNameInCaseInsensitiveManner() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"http://www.foo.com/bar/baz");
        store.add(uri, ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/bar"));
        store.add(uri, ClientCookieDecoder.LAX.decode("alpha=VALUE2; Domain=www.foo.com; path=/bar"));
        Assert.assertTrue((store.getAll().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).value().equals("VALUE2"));
    }

    private void handleCookiePathInCaseSensitiveManner() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/foo/bar"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1"));
        Assert.assertTrue((boolean)store.get(Uri.create((String)"http://www.FoO.com/Foo/bAr")).isEmpty());
    }

    private void ignoreQueryParametersInUri() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com/bar?query1"), ClientCookieDecoder.LAX.decode("ALPHA=VALUE1; Domain=www.foo.com; path=/"));
        Assert.assertTrue((store.get(Uri.create((String)"http://www.foo.com/bar?query2")).size() == 1 ? 1 : 0) != 0);
    }

    private void shouldServerOnSubdomainWhenDomainMatches() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"https://x.foo.org/"), ClientCookieDecoder.LAX.decode("cookie1=VALUE1; Path=/; Domain=foo.org;"));
        Assert.assertTrue((store.get(Uri.create((String)"https://y.x.foo.org/")).size() == 1 ? 1 : 0) != 0);
    }

    private void replaceCookieWhenSetOnSamePathBySameUri() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        Uri uri = Uri.create((String)"https://foo.org/");
        store.add(uri, ClientCookieDecoder.LAX.decode("cookie1=VALUE1; Path=/"));
        store.add(uri, ClientCookieDecoder.LAX.decode("cookie1=VALUE2; Path=/"));
        store.add(uri, ClientCookieDecoder.LAX.decode("cookie1=VALUE3; Path=/"));
        Assert.assertTrue((store.getAll().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).value().equals("VALUE3"));
    }

    private void handleMultipleCookieOfSameNameOnDifferentPaths() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://www.foo.com"), ClientCookieDecoder.LAX.decode("cookie=VALUE0; path=/"));
        store.add(Uri.create((String)"http://www.foo.com/foo/bar"), ClientCookieDecoder.LAX.decode("cookie=VALUE1; path=/foo/bar/"));
        store.add(Uri.create((String)"http://www.foo.com/foo/baz"), ClientCookieDecoder.LAX.decode("cookie=VALUE2; path=/foo/baz/"));
        Uri uri1 = Uri.create((String)"http://www.foo.com/foo/bar/");
        List cookies1 = store.get(uri1);
        Assert.assertTrue((cookies1.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((cookies1.stream().filter(c -> c.value().equals("VALUE0") || c.value().equals("VALUE1")).count() == 2L ? 1 : 0) != 0);
        Uri uri2 = Uri.create((String)"http://www.foo.com/foo/baz/");
        List cookies2 = store.get(uri2);
        Assert.assertTrue((cookies2.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((cookies2.stream().filter(c -> c.value().equals("VALUE0") || c.value().equals("VALUE2")).count() == 2L ? 1 : 0) != 0);
    }

    private void handleTrailingSlashesInPaths() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"https://vagrant.moolb.com/app/consumer/j_spring_cas_security_check?ticket=ST-5-Q7gzqPpvG3N3Bb02bm3q-llinder-vagrantmgr.moolb.com"), ClientCookieDecoder.LAX.decode("JSESSIONID=211D17F016132BCBD31D9ABB31D90960; Path=/app/consumer/; HttpOnly"));
        Assert.assertTrue((store.getAll().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(Uri.create((String)"https://vagrant.moolb.com/app/consumer/")).get(0)).value().equals("211D17F016132BCBD31D9ABB31D90960"));
    }

    private void returnMultipleCookiesEvenIfTheyHaveSameName() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"http://foo.com"), ClientCookieDecoder.LAX.decode("JSESSIONID=FOO; Domain=.foo.com"));
        store.add(Uri.create((String)"http://sub.foo.com"), ClientCookieDecoder.LAX.decode("JSESSIONID=BAR; Domain=sub.foo.com"));
        Uri uri1 = Uri.create((String)"http://sub.foo.com");
        List cookies1 = store.get(uri1);
        Assert.assertTrue((cookies1.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((cookies1.stream().filter(c -> c.value().equals("FOO") || c.value().equals("BAR")).count() == 2L ? 1 : 0) != 0);
        String result = ClientCookieEncoder.LAX.encode(new Cookie[]{(Cookie)cookies1.get(0), (Cookie)cookies1.get(1)});
        Assert.assertTrue((boolean)result.equals("JSESSIONID=FOO; JSESSIONID=BAR"));
    }

    private void shouldServeCookiesBasedOnTheUriScheme() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"https://foo.org/moodle/"), ClientCookieDecoder.LAX.decode("cookie1=VALUE1; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE2; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE3; Path=/; Secure"));
        Uri uri = Uri.create((String)"https://foo.org/moodle/login");
        Assert.assertTrue((store.getAll().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).value().equals("VALUE3"));
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).isSecure());
    }

    private void shouldAlsoServeNonSecureCookiesBasedOnTheUriScheme() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"https://foo.org/moodle/"), ClientCookieDecoder.LAX.decode("cookie1=VALUE1; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE2; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE3; Path=/; HttpOnly"));
        Uri uri = Uri.create((String)"https://foo.org/moodle/login");
        Assert.assertTrue((store.getAll().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).value().equals("VALUE3"));
        Assert.assertTrue((!((Cookie)store.get(uri).get(0)).isSecure() ? 1 : 0) != 0);
    }

    private void shouldNotServeSecureCookiesForDefaultRetrievedHttpUriScheme() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"https://foo.org/moodle/"), ClientCookieDecoder.LAX.decode("cookie1=VALUE1; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE2; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE3; Path=/; Secure"));
        Uri uri = Uri.create((String)"http://foo.org/moodle/login");
        Assert.assertTrue((boolean)store.get(uri).isEmpty());
    }

    private void shouldServeSecureCookiesForSpecificallyRetrievedHttpUriScheme() {
        ThreadSafeCookieStore store = new ThreadSafeCookieStore();
        store.add(Uri.create((String)"https://foo.org/moodle/"), ClientCookieDecoder.LAX.decode("cookie1=VALUE1; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE2; Path=/"));
        store.add(Uri.create((String)"https://foo.org:443/moodle/login"), ClientCookieDecoder.LAX.decode("cookie1=VALUE3; Path=/; Secure"));
        Uri uri = Uri.create((String)"https://foo.org/moodle/login");
        Assert.assertTrue((store.get(uri).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).value().equals("VALUE3"));
        Assert.assertTrue((boolean)((Cookie)store.get(uri).get(0)).isSecure());
    }
}

