/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.ClientStats;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HostStats;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClientStatsTest
extends AbstractBasicTest {
    private static final String hostname = "localhost";

    @Test
    public void testClientStatus() throws Throwable {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setKeepAlive(true).setPooledConnectionIdleTimeout(5000));){
            String url = this.getTargetUrl();
            ClientStats emptyStats = client.getClientStats();
            Assert.assertEquals((String)emptyStats.toString(), (String)"There are 0 total connections, 0 are active and 0 are idle.");
            Assert.assertEquals((long)emptyStats.getTotalActiveConnectionCount(), (long)0L);
            Assert.assertEquals((long)emptyStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)emptyStats.getTotalConnectionCount(), (long)0L);
            Assert.assertNull(emptyStats.getStatsPerHost().get(hostname));
            List<ListenableFuture> futures = Stream.generate(() -> ((BoundRequestBuilder)client.prepareGet(url).setHeader((CharSequence)"LockThread", "6")).execute()).limit(5L).collect(Collectors.toList());
            Thread.sleep(2000L);
            ClientStats activeStats = client.getClientStats();
            Assert.assertEquals((String)activeStats.toString(), (String)"There are 5 total connections, 5 are active and 0 are idle.");
            Assert.assertEquals((long)activeStats.getTotalActiveConnectionCount(), (long)5L);
            Assert.assertEquals((long)activeStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)activeStats.getTotalConnectionCount(), (long)5L);
            Assert.assertEquals((long)((HostStats)activeStats.getStatsPerHost().get(hostname)).getHostConnectionCount(), (long)5L);
            futures.forEach(future -> {
                Response cfr_ignored_0 = (Response)future.toCompletableFuture().join();
            });
            Thread.sleep(1000L);
            ClientStats idleStats = client.getClientStats();
            Assert.assertEquals((String)idleStats.toString(), (String)"There are 5 total connections, 0 are active and 5 are idle.");
            Assert.assertEquals((long)idleStats.getTotalActiveConnectionCount(), (long)0L);
            Assert.assertEquals((long)idleStats.getTotalIdleConnectionCount(), (long)5L);
            Assert.assertEquals((long)idleStats.getTotalConnectionCount(), (long)5L);
            Assert.assertEquals((long)((HostStats)idleStats.getStatsPerHost().get(hostname)).getHostConnectionCount(), (long)5L);
            List<ListenableFuture> repeatedFutures = Stream.generate(() -> ((BoundRequestBuilder)client.prepareGet(url).setHeader((CharSequence)"LockThread", "6")).execute()).limit(3L).collect(Collectors.toList());
            Thread.sleep(2000L);
            ClientStats activeCachedStats = client.getClientStats();
            Assert.assertEquals((String)activeCachedStats.toString(), (String)"There are 5 total connections, 3 are active and 2 are idle.");
            Assert.assertEquals((long)activeCachedStats.getTotalActiveConnectionCount(), (long)3L);
            Assert.assertEquals((long)activeCachedStats.getTotalIdleConnectionCount(), (long)2L);
            Assert.assertEquals((long)activeCachedStats.getTotalConnectionCount(), (long)5L);
            Assert.assertEquals((long)((HostStats)activeCachedStats.getStatsPerHost().get(hostname)).getHostConnectionCount(), (long)5L);
            repeatedFutures.forEach(future -> {
                Response cfr_ignored_0 = (Response)future.toCompletableFuture().join();
            });
            Thread.sleep(1000L);
            ClientStats idleCachedStats = client.getClientStats();
            Assert.assertEquals((String)idleCachedStats.toString(), (String)"There are 3 total connections, 0 are active and 3 are idle.");
            Assert.assertEquals((long)idleCachedStats.getTotalActiveConnectionCount(), (long)0L);
            Assert.assertEquals((long)idleCachedStats.getTotalIdleConnectionCount(), (long)3L);
            Assert.assertEquals((long)idleCachedStats.getTotalConnectionCount(), (long)3L);
            Assert.assertEquals((long)((HostStats)idleCachedStats.getStatsPerHost().get(hostname)).getHostConnectionCount(), (long)3L);
            Thread.sleep(5000L);
            ClientStats timeoutStats = client.getClientStats();
            Assert.assertEquals((String)timeoutStats.toString(), (String)"There are 0 total connections, 0 are active and 0 are idle.");
            Assert.assertEquals((long)timeoutStats.getTotalActiveConnectionCount(), (long)0L);
            Assert.assertEquals((long)timeoutStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)timeoutStats.getTotalConnectionCount(), (long)0L);
            Assert.assertNull(timeoutStats.getStatsPerHost().get(hostname));
        }
    }

    @Test
    public void testClientStatusNoKeepalive() throws Throwable {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setKeepAlive(false));){
            String url = this.getTargetUrl();
            ClientStats emptyStats = client.getClientStats();
            Assert.assertEquals((String)emptyStats.toString(), (String)"There are 0 total connections, 0 are active and 0 are idle.");
            Assert.assertEquals((long)emptyStats.getTotalActiveConnectionCount(), (long)0L);
            Assert.assertEquals((long)emptyStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)emptyStats.getTotalConnectionCount(), (long)0L);
            Assert.assertNull(emptyStats.getStatsPerHost().get(hostname));
            List<ListenableFuture> futures = Stream.generate(() -> ((BoundRequestBuilder)client.prepareGet(url).setHeader((CharSequence)"LockThread", "6")).execute()).limit(5L).collect(Collectors.toList());
            Thread.sleep(2000L);
            ClientStats activeStats = client.getClientStats();
            Assert.assertEquals((String)activeStats.toString(), (String)"There are 5 total connections, 5 are active and 0 are idle.");
            Assert.assertEquals((long)activeStats.getTotalActiveConnectionCount(), (long)5L);
            Assert.assertEquals((long)activeStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)activeStats.getTotalConnectionCount(), (long)5L);
            Assert.assertEquals((long)((HostStats)activeStats.getStatsPerHost().get(hostname)).getHostConnectionCount(), (long)5L);
            futures.forEach(future -> {
                Response cfr_ignored_0 = (Response)future.toCompletableFuture().join();
            });
            Thread.sleep(1000L);
            ClientStats idleStats = client.getClientStats();
            Assert.assertEquals((String)idleStats.toString(), (String)"There are 0 total connections, 0 are active and 0 are idle.");
            Assert.assertEquals((long)idleStats.getTotalActiveConnectionCount(), (long)0L);
            Assert.assertEquals((long)idleStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)idleStats.getTotalConnectionCount(), (long)0L);
            Assert.assertNull(idleStats.getStatsPerHost().get(hostname));
            List<ListenableFuture> repeatedFutures = Stream.generate(() -> ((BoundRequestBuilder)client.prepareGet(url).setHeader((CharSequence)"LockThread", "6")).execute()).limit(3L).collect(Collectors.toList());
            Thread.sleep(2000L);
            ClientStats activeCachedStats = client.getClientStats();
            Assert.assertEquals((String)activeCachedStats.toString(), (String)"There are 3 total connections, 3 are active and 0 are idle.");
            Assert.assertEquals((long)activeCachedStats.getTotalActiveConnectionCount(), (long)3L);
            Assert.assertEquals((long)activeCachedStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)activeCachedStats.getTotalConnectionCount(), (long)3L);
            Assert.assertEquals((long)((HostStats)activeCachedStats.getStatsPerHost().get(hostname)).getHostConnectionCount(), (long)3L);
            repeatedFutures.forEach(future -> {
                Response cfr_ignored_0 = (Response)future.toCompletableFuture().join();
            });
            Thread.sleep(1000L);
            ClientStats idleCachedStats = client.getClientStats();
            Assert.assertEquals((String)idleCachedStats.toString(), (String)"There are 0 total connections, 0 are active and 0 are idle.");
            Assert.assertEquals((long)idleCachedStats.getTotalActiveConnectionCount(), (long)0L);
            Assert.assertEquals((long)idleCachedStats.getTotalIdleConnectionCount(), (long)0L);
            Assert.assertEquals((long)idleCachedStats.getTotalConnectionCount(), (long)0L);
            Assert.assertNull(idleCachedStats.getStatsPerHost().get(hostname));
        }
    }
}

