/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ByteBufferCapacityTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new BasicHandler();
    }

    @Test
    public void basicByteBufferTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            File largeFile = TestUtils.createTempFile(1024000);
            final AtomicInteger byteReceived = new AtomicInteger();
            Response response = (Response)((BoundRequestBuilder)c.preparePut(this.getTargetUrl()).setBody(largeFile)).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    byteReceived.addAndGet(content.getBodyByteBuffer().capacity());
                    return super.onBodyPartReceived(content);
                }
            }).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((long)byteReceived.get(), (long)largeFile.length());
            Assert.assertEquals((long)response.getResponseBody().length(), (long)largeFile.length());
        }
    }

    @Override
    public String getTargetUrl() {
        return String.format("http://localhost:%d/foo/test", this.port1);
    }

    private class BasicHandler
    extends AbstractHandler {
        private BasicHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                httpResponse.addHeader("X-" + param, httpRequest.getHeader(param));
            }
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                int read;
                ServletInputStream in = httpRequest.getInputStream();
                ServletOutputStream out = httpResponse.getOutputStream();
                while ((read = in.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

