/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.channel.KeepAliveStrategy;
import org.asynchttpclient.test.EventCollectingHandler;
import org.asynchttpclient.test.TestUtils;
import org.asynchttpclient.testserver.HttpServer;
import org.asynchttpclient.testserver.HttpTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BasicHttpsTest
extends HttpTest {
    private static HttpServer server;

    @BeforeClass
    public static void start() throws Throwable {
        server = new HttpServer();
        server.start();
    }

    @AfterClass
    public static void stop() throws Throwable {
        server.close();
    }

    private static String getTargetUrl() {
        return server.getHttpsUrl() + "/foo/bar";
    }

    @Test
    public void postFileOverHttps() throws Throwable {
        this.logger.debug(">>> postBodyOverHttps");
        this.withClient(Dsl.config().setSslEngineFactory(TestUtils.createSslEngineFactory())).run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            Response resp = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(TestUtils.SIMPLE_TEXT_FILE)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute().get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)TestUtils.SIMPLE_TEXT_FILE_STRING);
        }));
        this.logger.debug("<<< postBodyOverHttps");
    }

    @Test
    public void postLargeFileOverHttps() throws Throwable {
        this.logger.debug(">>> postLargeFileOverHttps");
        this.withClient(Dsl.config().setSslEngineFactory(TestUtils.createSslEngineFactory())).run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            Response resp = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(TestUtils.LARGE_IMAGE_FILE)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "image/png")).execute().get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((long)resp.getResponseBodyAsBytes().length, (long)TestUtils.LARGE_IMAGE_FILE.length());
        }));
        this.logger.debug("<<< postLargeFileOverHttps");
    }

    @Test
    public void multipleSequentialPostRequestsOverHttps() throws Throwable {
        this.logger.debug(">>> multipleSequentialPostRequestsOverHttps");
        this.withClient(Dsl.config().setSslEngineFactory(TestUtils.createSslEngineFactory())).run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            server.enqueueEcho();
            String body = "hello there";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(body)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(body)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
        }));
        this.logger.debug("<<< multipleSequentialPostRequestsOverHttps");
    }

    @Test
    public void multipleConcurrentPostRequestsOverHttpsWithDisabledKeepAliveStrategy() throws Throwable {
        this.logger.debug(">>> multipleConcurrentPostRequestsOverHttpsWithDisabledKeepAliveStrategy");
        KeepAliveStrategy keepAliveStrategy = (ahcRequest, nettyRequest, nettyResponse) -> !ahcRequest.getUri().isSecured();
        this.withClient(Dsl.config().setSslEngineFactory(TestUtils.createSslEngineFactory()).setKeepAliveStrategy(keepAliveStrategy)).run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            server.enqueueEcho();
            server.enqueueEcho();
            String body = "hello there";
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(body)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute();
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(body)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute();
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(body)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute().get();
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
        }));
        this.logger.debug("<<< multipleConcurrentPostRequestsOverHttpsWithDisabledKeepAliveStrategy");
    }

    @Test
    public void reconnectAfterFailedCertificationPath() throws Throwable {
        this.logger.debug(">>> reconnectAfterFailedCertificationPath");
        AtomicBoolean trust = new AtomicBoolean();
        this.withClient(Dsl.config().setMaxRequestRetry(0).setSslEngineFactory(TestUtils.createSslEngineFactory(trust))).run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            server.enqueueEcho();
            String body = "hello there";
            Throwable cause = null;
            try {
                ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(body)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute().get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                cause = e.getCause();
            }
            Assert.assertNotNull((Object)cause);
            trust.set(true);
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody(body)).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "text/html")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
        }));
        this.logger.debug("<<< reconnectAfterFailedCertificationPath");
    }

    @Test(timeOut=2000L, expectedExceptions={SSLHandshakeException.class})
    public void failInstantlyIfNotAllowedSelfSignedCertificate() throws Throwable {
        this.logger.debug(">>> failInstantlyIfNotAllowedSelfSignedCertificate");
        this.withClient(Dsl.config().setMaxRequestRetry(0).setRequestTimeout(2000)).run(client -> this.withServer(server).run(server -> {
            try {
                client.prepareGet(BasicHttpsTest.getTargetUrl()).execute().get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause().getCause();
            }
        }));
        this.logger.debug("<<< failInstantlyIfNotAllowedSelfSignedCertificate");
    }

    @Test
    public void testNormalEventsFired() throws Throwable {
        this.logger.debug(">>> testNormalEventsFired");
        this.withClient(Dsl.config().setSslEngineFactory(TestUtils.createSslEngineFactory())).run(client -> this.withServer(server).run(server -> {
            EventCollectingHandler handler = new EventCollectingHandler();
            server.enqueueEcho();
            ((BoundRequestBuilder)client.preparePost(BasicHttpsTest.getTargetUrl()).setBody("whatever")).execute((AsyncHandler)handler).get(3L, TimeUnit.SECONDS);
            handler.waitForCompletion(3, TimeUnit.SECONDS);
            Object[] expectedEvents = new Object[]{"ConnectionPool", "HostnameResolution", "HostnameResolutionSuccess", "ConnectionOpen", "ConnectionSuccess", "TlsHandshake", "TlsHandshakeSuccess", "RequestSend", "HeadersWritten", "StatusReceived", "HeadersReceived", "ConnectionOffer", "Completed"};
            Assert.assertEquals((Object[])handler.firedEvents.toArray(), (Object[])expectedEvents, (String)("Got " + Arrays.toString(handler.firedEvents.toArray())));
        }));
        this.logger.debug("<<< testNormalEventsFired");
    }
}

