/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.Cookie;
import org.apache.hive.druid.io.netty.handler.codec.http.cookie.DefaultCookie;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.handler.MaxRedirectException;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.asynchttpclient.test.EventCollectingHandler;
import org.asynchttpclient.test.TestUtils;
import org.asynchttpclient.testserver.HttpServer;
import org.asynchttpclient.testserver.HttpTest;
import org.asynchttpclient.util.DateUtils;
import org.asynchttpclient.util.ThrowableUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BasicHttpTest
extends HttpTest {
    private static HttpServer server;

    @BeforeClass
    public static void start() throws Throwable {
        server = new HttpServer();
        server.start();
    }

    @AfterClass
    public static void stop() throws Throwable {
        server.close();
    }

    private static String getTargetUrl() {
        return server.getHttpUrl() + "/foo/bar";
    }

    @Test
    public void getRootUrl() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            String url = server.getHttpUrl();
            server.enqueueOk();
            Response response = (Response)client.executeRequest(Dsl.get((String)url), (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter()).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getUri().toUrl(), (String)url);
        }));
    }

    @Test
    public void getUrlWithPathWithoutQuery() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueOk();
            Response response = (Response)client.executeRequest(Dsl.get((String)BasicHttpTest.getTargetUrl()), (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter()).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getUri().toUrl(), (String)BasicHttpTest.getTargetUrl());
        }));
    }

    @Test
    public void getUrlWithPathWithQuery() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            String targetUrl = BasicHttpTest.getTargetUrl() + "?q=+%20x";
            Request request = Dsl.get((String)targetUrl).build();
            Assert.assertEquals((String)request.getUrl(), (String)targetUrl);
            server.enqueueOk();
            Response response = (Response)client.executeRequest(request, (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter()).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getUri().toUrl(), (String)targetUrl);
        }));
    }

    @Test
    public void getUrlWithPathWithQueryParams() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueOk();
            Response response = (Response)client.executeRequest((RequestBuilder)Dsl.get((String)BasicHttpTest.getTargetUrl()).addQueryParam("q", "a b"), (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter()).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getUri().toUrl(), (String)(BasicHttpTest.getTargetUrl() + "?q=a%20b"));
        }));
    }

    @Test
    public void getResponseBody() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            final String body = "Hello World";
            server.enqueueResponse(response -> {
                response.setStatus(200);
                response.setContentType("text/html;charset=UTF-8");
                TestUtils.writeResponseBody(response, "Hello World");
            });
            client.executeRequest(Dsl.get((String)BasicHttpTest.getTargetUrl()), (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    String contentLengthHeader = response.getHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    Assert.assertNotNull((Object)contentLengthHeader);
                    Assert.assertEquals((int)Integer.parseInt(contentLengthHeader), (int)body.length());
                    TestUtils.assertContentTypesEquals(response.getContentType(), "text/html;charset=UTF-8");
                    Assert.assertEquals((String)response.getResponseBody(), (String)body);
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void getWithHeaders() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            for (int i = 1; i < 5; ++i) {
                h.add("Test" + i, (Object)("Test" + i));
            }
            server.enqueueEcho();
            client.executeRequest((RequestBuilder)Dsl.get((String)BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h), (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    for (int i = 1; i < 5; ++i) {
                        Assert.assertEquals((String)response.getHeader((CharSequence)("X-Test" + i)), (String)("Test" + i));
                    }
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void postWithHeadersAndFormParams() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (int i = 0; i < 5; ++i) {
                m.put("param_" + i, Collections.singletonList("value_" + i));
            }
            Request request = ((RequestBuilder)((RequestBuilder)Dsl.post((String)BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setFormParams(m)).build();
            server.enqueueEcho();
            client.executeRequest(request, (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    for (int i = 1; i < 5; ++i) {
                        Assert.assertEquals((String)response.getHeader((CharSequence)("X-param_" + i)), (String)("value_" + i));
                    }
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void headHasEmptyBody() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueOk();
            Response response = (Response)client.executeRequest(Dsl.head((String)BasicHttpTest.getTargetUrl()), (AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)response.getResponseBody().isEmpty());
        }));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void nullSchemeThrowsNPE() throws Throwable {
        this.withClient().run(client -> client.prepareGet("gatling.io").execute());
    }

    @Test
    public void jettyRespondsWithChunkedTransferEncoding() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    Assert.assertEquals((String)response.getHeader((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (String)HttpHeaderValues.CHUNKED.toString());
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void getWithCookies() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultCookie coo = new DefaultCookie("foo", "value");
            coo.setDomain("/");
            coo.setPath("/");
            server.enqueueEcho();
            ((BoundRequestBuilder)client.prepareGet(BasicHttpTest.getTargetUrl()).addCookie((Cookie)coo)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    List cookies = response.getCookies();
                    Assert.assertEquals((int)cookies.size(), (int)1);
                    Assert.assertEquals((String)((Cookie)cookies.get(0)).toString(), (String)"foo=value");
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void defaultRequestBodyEncodingIsUtf8() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            Response response = (Response)((BoundRequestBuilder)client.preparePost(BasicHttpTest.getTargetUrl()).setBody("\u017d\u017d\u017d\u017d\u017d\u017d")).execute().get();
            Assert.assertEquals((byte[])response.getResponseBodyAsBytes(), (byte[])"\u017d\u017d\u017d\u017d\u017d\u017d".getBytes(StandardCharsets.UTF_8));
        }));
    }

    @Test
    public void postFormParametersAsBodyString() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_").append(i).append("=value_").append(i).append("&");
            }
            sb.setLength(sb.length() - 1);
            server.enqueueEcho();
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setBody(sb.toString())).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    for (int i = 1; i < 5; ++i) {
                        Assert.assertEquals((String)response.getHeader((CharSequence)("X-param_" + i)), (String)("value_" + i));
                    }
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void postFormParametersAsBodyStream() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_").append(i).append("=value_").append(i).append("&");
            }
            sb.setLength(sb.length() - 1);
            server.enqueueEcho();
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setBody((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)))).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    for (int i = 1; i < 5; ++i) {
                        Assert.assertEquals((String)response.getHeader((CharSequence)("X-param_" + i)), (String)("value_" + i));
                    }
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void putFormParametersAsBodyStream() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_").append(i).append("=value_").append(i).append("&");
            }
            sb.setLength(sb.length() - 1);
            ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes());
            server.enqueueEcho();
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePut(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setBody((InputStream)is)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    for (int i = 1; i < 5; ++i) {
                        Assert.assertEquals((String)response.getHeader((CharSequence)("X-param_" + i)), (String)("value_" + i));
                    }
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void postSingleStringPart() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            ((BoundRequestBuilder)client.preparePost(BasicHttpTest.getTargetUrl()).addBodyPart((Part)new StringPart("foo", "bar"))).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    String requestContentType = response.getHeader((CharSequence)("X-" + HttpHeaderNames.CONTENT_TYPE));
                    String boundary = requestContentType.substring(requestContentType.indexOf("boundary") + "boundary".length() + 1);
                    Assert.assertTrue((boolean)response.getResponseBody().regionMatches(false, "--".length(), boundary, 0, boundary.length()));
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void postWithBody() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            client.preparePost(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((String)response.getHeader((CharSequence)("X-" + HttpHeaderNames.CONTENT_LENGTH)), (String)"0");
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void getVirtualHost() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            String virtualHost = "localhost:" + server.getHttpPort();
            server.enqueueEcho();
            Response response = (Response)((BoundRequestBuilder)client.prepareGet(BasicHttpTest.getTargetUrl()).setVirtualHost(virtualHost)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter()).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            if (response.getHeader((CharSequence)("X-" + HttpHeaderNames.HOST)) == null) {
                System.err.println(response);
            }
            Assert.assertEquals((String)response.getHeader((CharSequence)("X-" + HttpHeaderNames.HOST)), (String)virtualHost);
        }));
    }

    @Test(expectedExceptions={CancellationException.class})
    public void cancelledFutureThrowsCancellationException() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            headers.add("X-Delay", (Object)5000);
            server.enqueueEcho();
            ListenableFuture future = ((BoundRequestBuilder)client.prepareGet(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)headers)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                }
            });
            future.cancel(true);
            future.get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void futureTimeOutThrowsTimeoutException() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            headers.add("X-Delay", (Object)5000);
            server.enqueueEcho();
            ListenableFuture future = ((BoundRequestBuilder)client.prepareGet(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)headers)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                }
            });
            future.get(2L, TimeUnit.SECONDS);
        }));
    }

    @Test(expectedExceptions={ConnectException.class})
    public void connectFailureThrowsConnectException() throws Throwable {
        this.withClient().run(client -> {
            int dummyPort = TestUtils.findFreePort();
            try {
                client.preparePost(String.format("http://localhost:%d/", dummyPort)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                    }
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException ex) {
                throw ex.getCause();
            }
        });
    }

    @Test
    public void connectFailureNotifiesHandlerWithConnectException() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            final CountDownLatch l = new CountDownLatch(1);
            int port = TestUtils.findFreePort();
            client.prepareGet(String.format("http://localhost:%d/", port)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        Assert.assertTrue((boolean)(t instanceof ConnectException));
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }));
    }

    @Test(expectedExceptions={UnknownHostException.class})
    public void unknownHostThrowsUnknownHostException() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            try {
                client.prepareGet("http://null.gatling.io").execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                    }
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }));
    }

    @Test
    public void getEmptyBody() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueOk();
            Response response = (Response)client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter()).get(30L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)response.getResponseBody().isEmpty());
        }));
    }

    @Test
    public void getEmptyBodyNotifiesHandler() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            final AtomicBoolean handlerWasNotified = new AtomicBoolean();
            server.enqueueOk();
            client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    handlerWasNotified.set(true);
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)handlerWasNotified.get());
        }));
    }

    @Test
    public void exceptionInOnCompletedGetNotifiedToOnThrowable() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference message = new AtomicReference();
            server.enqueueOk();
            client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    throw (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new IllegalStateException("FOO"), BasicHttpTest.class, (String)"exceptionInOnCompletedGetNotifiedToOnThrowable");
                }

                @Override
                public void onThrowable(Throwable t) {
                    message.set(t.getMessage());
                    latch.countDown();
                }
            });
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
            Assert.assertEquals((String)((String)message.get()), (String)"FOO");
        }));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void exceptionInOnCompletedGetNotifiedToFuture() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueOk();
            ListenableFuture whenResponse = client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    throw (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new IllegalStateException("FOO"), BasicHttpTest.class, (String)"exceptionInOnCompletedGetNotifiedToFuture");
                }

                @Override
                public void onThrowable(Throwable t) {
                }
            });
            try {
                whenResponse.get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }));
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void configTimeoutNotifiesOnThrowableAndFuture() throws Throwable {
        this.withClient(Dsl.config().setRequestTimeout(1000)).run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            headers.add("X-Delay", (Object)5000);
            final AtomicBoolean onCompletedWasNotified = new AtomicBoolean();
            final AtomicBoolean onThrowableWasNotifiedWithTimeoutException = new AtomicBoolean();
            final CountDownLatch latch = new CountDownLatch(1);
            server.enqueueEcho();
            ListenableFuture whenResponse = ((BoundRequestBuilder)client.prepareGet(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)headers)).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    onCompletedWasNotified.set(true);
                    latch.countDown();
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    onThrowableWasNotifiedWithTimeoutException.set(t instanceof TimeoutException);
                    latch.countDown();
                }
            });
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
            Assert.assertFalse((boolean)onCompletedWasNotified.get());
            Assert.assertTrue((boolean)onThrowableWasNotifiedWithTimeoutException.get());
            try {
                whenResponse.get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }));
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void configRequestTimeoutHappensInDueTime() throws Throwable {
        this.withClient(Dsl.config().setRequestTimeout(1000)).run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            h.add("X-Delay", (Object)2000);
            server.enqueueEcho();
            long start = DateUtils.unpreciseMillisTime();
            try {
                ((BoundRequestBuilder)((BoundRequestBuilder)client.prepareGet(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setUrl(BasicHttpTest.getTargetUrl())).execute().get();
            }
            catch (Throwable ex) {
                long elapsedTime = DateUtils.unpreciseMillisTime() - start;
                Assert.assertTrue((elapsedTime >= 1000L && elapsedTime <= 1500L ? 1 : 0) != 0);
                throw ex.getCause();
            }
        }));
    }

    @Test
    public void getProperPathAndQueryString() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            client.prepareGet(BasicHttpTest.getTargetUrl() + "?foo=bar").execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertTrue((response.getHeader((CharSequence)"X-PathInfo") != null ? 1 : 0) != 0);
                    Assert.assertTrue((response.getHeader((CharSequence)"X-QueryString") != null ? 1 : 0) != 0);
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void connectionIsReusedForSequentialRequests() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            final CountDownLatch l = new CountDownLatch(2);
            TestUtils.AsyncCompletionHandlerAdapter handler = new TestUtils.AsyncCompletionHandlerAdapter(){
                volatile String clientPort;

                @Override
                public Response onCompleted(Response response) {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)200);
                        if (this.clientPort == null) {
                            this.clientPort = response.getHeader((CharSequence)"X-ClientPort");
                        } else {
                            Assert.assertEquals((String)response.getHeader((CharSequence)"X-ClientPort"), (String)this.clientPort);
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            };
            server.enqueueEcho();
            client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)handler).get(30L, TimeUnit.SECONDS);
            server.enqueueEcho();
            client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)handler);
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }));
    }

    @Test(expectedExceptions={MaxRedirectException.class})
    public void reachingMaxRedirectThrowsMaxRedirectException() throws Throwable {
        this.withClient(Dsl.config().setMaxRedirects(1).setFollowRedirect(true)).run(client -> this.withServer(server).run(server -> {
            try {
                server.enqueueRedirect(301, BasicHttpTest.getTargetUrl());
                server.enqueueRedirect(301, BasicHttpTest.getTargetUrl());
                client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                    @Override
                    public Response onCompleted(Response response) {
                        Assert.fail((String)"Should not be here");
                        return response;
                    }

                    @Override
                    public void onThrowable(Throwable t) {
                    }
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }));
    }

    @Test
    public void nonBlockingNestedRequetsFromIoThreadAreFine() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            final int maxNested = 5;
            final CountDownLatch latch = new CountDownLatch(2);
            TestUtils.AsyncCompletionHandlerAdapter handler = new TestUtils.AsyncCompletionHandlerAdapter(){
                private AtomicInteger nestedCount = new AtomicInteger(0);

                @Override
                public Response onCompleted(Response response) {
                    try {
                        if (this.nestedCount.getAndIncrement() < maxNested) {
                            client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)this);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                    return response;
                }
            };
            for (int i = 0; i < 6; ++i) {
                server.enqueueOk();
            }
            client.prepareGet(BasicHttpTest.getTargetUrl()).execute((AsyncHandler)handler);
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }));
    }

    @Test
    public void optionsIsSupported() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            Response response = (Response)client.prepareOptions(BasicHttpTest.getTargetUrl()).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader((CharSequence)"Allow"), (String)"GET,HEAD,POST,OPTIONS,TRACE");
        }));
    }

    @Test
    public void cancellingFutureNotifiesOnThrowableWithCancellationException() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            h.add("X-Delay", (Object)2000);
            final CountDownLatch latch = new CountDownLatch(1);
            ListenableFuture future = ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setBody("Body")).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                    if (t instanceof CancellationException) {
                        latch.countDown();
                    }
                }
            });
            future.cancel(true);
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }));
    }

    @Test
    public void getShouldAllowBody() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> ((BoundRequestBuilder)client.prepareGet(BasicHttpTest.getTargetUrl()).setBody("Boo!")).execute()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void malformedUriThrowsException() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> client.prepareGet(String.format("http:localhost:%d/foo/test", server.getHttpPort())).build()));
    }

    @Test
    public void emptyResponseBodyBytesAreEmpty() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            Response response = (Response)client.prepareGet(BasicHttpTest.getTargetUrl()).execute().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((byte[])response.getResponseBodyAsBytes(), (byte[])new byte[0]);
        }));
    }

    @Test
    public void newConnectionEventsAreFired() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            Request request = Dsl.get((String)BasicHttpTest.getTargetUrl()).build();
            EventCollectingHandler handler = new EventCollectingHandler();
            client.executeRequest(request, (AsyncHandler)handler).get(3L, TimeUnit.SECONDS);
            handler.waitForCompletion(3, TimeUnit.SECONDS);
            Object[] expectedEvents = new Object[]{"ConnectionPool", "HostnameResolution", "HostnameResolutionSuccess", "ConnectionOpen", "ConnectionSuccess", "RequestSend", "HeadersWritten", "StatusReceived", "HeadersReceived", "ConnectionOffer", "Completed"};
            Assert.assertEquals((Object[])handler.firedEvents.toArray(), (Object[])expectedEvents, (String)("Got " + Arrays.toString(handler.firedEvents.toArray())));
        }));
    }

    @Test
    public void requestingPlainHttpEndpointOverHttpsThrowsSslException() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            server.enqueueEcho();
            try {
                client.prepareGet(BasicHttpTest.getTargetUrl().replace("http", "https")).execute().get();
                Assert.fail((String)"Request shouldn't succeed");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof ConnectException), (String)"Cause should be a ConnectException");
                Assert.assertTrue((boolean)(e.getCause().getCause() instanceof SSLException), (String)"Root cause should be a SslException");
            }
        }));
    }

    @Test
    public void postUnboundedInputStreamAsBodyStream() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
            server.enqueue((Handler)new AbstractHandler(){
                HttpServer.EchoHandler chain = new HttpServer.EchoHandler();

                public void handle(String target, org.eclipse.jetty.server.Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
                    Assert.assertEquals((String)request.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString()), (String)HttpHeaderValues.CHUNKED.toString());
                    Assert.assertNull((Object)request.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString()));
                    this.chain.handle(target, request, httpServletRequest, httpServletResponse);
                }
            });
            server.enqueueEcho();
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setBody((InputStream)new ByteArrayInputStream("{}".getBytes(StandardCharsets.ISO_8859_1)))).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    Assert.assertEquals((String)response.getResponseBody(), (String)"{}");
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }

    @Test
    public void postInputStreamWithContentLengthAsBodyGenerator() throws Throwable {
        this.withClient().run(client -> this.withServer(server).run(server -> {
            DefaultHttpHeaders h = new DefaultHttpHeaders();
            h.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
            server.enqueue((Handler)new AbstractHandler(){
                HttpServer.EchoHandler chain = new HttpServer.EchoHandler();

                public void handle(String target, org.eclipse.jetty.server.Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
                    Assert.assertNull((Object)request.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString()));
                    Assert.assertEquals((String)request.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString()), (String)Integer.toString("{}".getBytes(StandardCharsets.ISO_8859_1).length));
                    this.chain.handle(target, request, httpServletRequest, httpServletResponse);
                }
            });
            byte[] bodyBytes = "{}".getBytes(StandardCharsets.ISO_8859_1);
            ByteArrayInputStream bodyStream = new ByteArrayInputStream(bodyBytes);
            ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(BasicHttpTest.getTargetUrl()).setHeaders((HttpHeaders)h)).setBody((BodyGenerator)new InputStreamBodyGenerator((InputStream)bodyStream, (long)bodyBytes.length))).execute((AsyncHandler)new TestUtils.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) {
                    Assert.assertEquals((int)response.getStatusCode(), (int)200);
                    Assert.assertEquals((String)response.getResponseBody(), (String)"{}");
                    return response;
                }
            }).get(30L, TimeUnit.SECONDS);
        }));
    }
}

