/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BasicAuthTest
extends AbstractBasicTest {
    private Server server2;
    private Server serverNoAuth;
    private int portNoAuth;

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.server);
        TestUtils.addBasicAuthHandler(this.server, (Handler)this.configureHandler());
        this.server.start();
        this.port1 = connector1.getLocalPort();
        this.server2 = new Server();
        ServerConnector connector2 = TestUtils.addHttpConnector(this.server2);
        TestUtils.addBasicAuthHandler(this.server2, (Handler)new RedirectHandler());
        this.server2.start();
        this.port2 = connector2.getLocalPort();
        this.serverNoAuth = new Server();
        ServerConnector connectorNoAuth = TestUtils.addHttpConnector(this.serverNoAuth);
        this.serverNoAuth.setHandler((Handler)new SimpleHandler());
        this.serverNoAuth.start();
        this.portNoAuth = connectorNoAuth.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        super.tearDownGlobal();
        this.server2.stop();
        this.serverNoAuth.stop();
    }

    @Override
    protected String getTargetUrl() {
        return "http://localhost:" + this.port1 + "/";
    }

    @Override
    protected String getTargetUrl2() {
        return "http://localhost:" + this.port2 + "/uff";
    }

    private String getTargetUrlNoAuth() {
        return "http://localhost:" + this.portNoAuth + "/";
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SimpleHandler();
    }

    @Test
    public void basicAuthTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").build())).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test
    public void redirectAndBasicAuthTest() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).setMaxRedirects(10));){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet(this.getTargetUrl2()).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").build())).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
        }
    }

    @Test
    public void basic401Test() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            BoundRequestBuilder r = (BoundRequestBuilder)((BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setHeader((CharSequence)"X-401", "401")).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").build());
            ListenableFuture f = r.execute((AsyncHandler)new AsyncHandler<Integer>(){
                private HttpResponseStatus status;

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
                    this.status = responseStatus;
                    if (this.status.getStatusCode() != 200) {
                        return AsyncHandler.State.ABORT;
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
                    return AsyncHandler.State.CONTINUE;
                }

                public Integer onCompleted() {
                    return this.status.getStatusCode();
                }
            });
            Integer statusCode = (Integer)f.get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)statusCode);
            Assert.assertEquals((int)statusCode, (int)401);
        }
    }

    @Test
    public void basicAuthTestPreemtiveTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet(this.getTargetUrlNoAuth()).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").setUsePreemptiveAuth(true).build())).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test
    public void basicAuthNegativeTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(Dsl.basicAuthRealm((String)"fake", (String)"admin").build())).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)401);
        }
    }

    @Test
    public void basicAuthInputStreamTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody((InputStream)new ByteArrayInputStream("test".getBytes()))).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").build())).execute();
            Response resp = (Response)f.get(30L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)"test");
        }
    }

    @Test
    public void basicAuthFileTest() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(TestUtils.SIMPLE_TEXT_FILE)).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").build())).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)TestUtils.SIMPLE_TEXT_FILE_STRING);
        }
    }

    @Test
    public void basicAuthAsyncConfigTest() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin")));){
            ListenableFuture f = ((BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(TestUtils.SIMPLE_TEXT_FILE_STRING)).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)TestUtils.SIMPLE_TEXT_FILE_STRING);
        }
    }

    @Test
    public void basicAuthFileNoKeepAliveTest() throws Exception {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setKeepAlive(false));){
            ListenableFuture f = ((BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(TestUtils.SIMPLE_TEXT_FILE)).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").build())).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)TestUtils.SIMPLE_TEXT_FILE_STRING);
        }
    }

    @Test
    public void noneAuthTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            BoundRequestBuilder r = (BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(Dsl.basicAuthRealm((String)"user", (String)"admin").build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader((CharSequence)"X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    public static class SimpleHandler
    extends AbstractHandler {
        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getHeader("X-401") != null) {
                response.setStatus(401);
                response.setContentLength(0);
            } else {
                int read;
                response.addHeader("X-Auth", request.getHeader("Authorization"));
                response.addHeader("X-" + HttpHeaderNames.CONTENT_LENGTH, String.valueOf(request.getContentLength()));
                response.setIntHeader("X-" + HttpHeaderNames.CONTENT_LENGTH, request.getContentLength());
                response.setStatus(200);
                int size = 10240;
                byte[] bytes = new byte[size];
                int contentLength = 0;
                do {
                    if ((read = request.getInputStream().read(bytes)) <= 0) continue;
                    contentLength += read;
                    response.getOutputStream().write(bytes, 0, read);
                } while (read >= 0);
                response.setContentLength(contentLength);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }

    private static class RedirectHandler
    extends AbstractHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(RedirectHandler.class);

        private RedirectHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            LOGGER.info("request: " + request.getRequestURI());
            if ("/uff".equals(request.getRequestURI())) {
                LOGGER.info("redirect to /bla");
                response.setStatus(302);
                response.setContentLength(0);
                response.setHeader("Location", "/bla");
            } else {
                LOGGER.info("got redirected" + request.getRequestURI());
                response.setStatus(200);
                response.addHeader("X-Auth", request.getHeader("Authorization"));
                response.addHeader("X-" + HttpHeaderNames.CONTENT_LENGTH, String.valueOf(request.getContentLength()));
                byte[] b = "content".getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

