/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class AsyncStreamLifecycleTest
extends AbstractBasicTest {
    private ExecutorService executorService = Executors.newFixedThreadPool(2);

    @Override
    @AfterClass
    public void tearDownGlobal() throws Exception {
        super.tearDownGlobal();
        this.executorService.shutdownNow();
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String s, Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.setContentType("text/plain;charset=utf-8");
                resp.setStatus(200);
                AsyncContext asyncContext = request.startAsync();
                PrintWriter writer = resp.getWriter();
                AsyncStreamLifecycleTest.this.executorService.submit(() -> {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        AsyncStreamLifecycleTest.this.logger.error("Failed to sleep for 100 ms.", (Throwable)e);
                    }
                    AsyncStreamLifecycleTest.this.logger.info("Delivering part1.");
                    writer.write("part1");
                    writer.flush();
                });
                AsyncStreamLifecycleTest.this.executorService.submit(() -> {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        AsyncStreamLifecycleTest.this.logger.error("Failed to sleep for 200 ms.", (Throwable)e);
                    }
                    AsyncStreamLifecycleTest.this.logger.info("Delivering part2.");
                    writer.write("part2");
                    writer.flush();
                    asyncContext.complete();
                });
                request.setHandled(true);
            }
        };
    }

    @Test
    public void testStream() throws Exception {
        try (AsyncHttpClient ahc = Dsl.asyncHttpClient();){
            final AtomicBoolean err = new AtomicBoolean(false);
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            final AtomicBoolean status = new AtomicBoolean(false);
            final AtomicInteger headers = new AtomicInteger(0);
            final CountDownLatch latch = new CountDownLatch(1);
            ahc.executeRequest(ahc.prepareGet(this.getTargetUrl()).build(), (AsyncHandler)new AsyncHandler<Object>(){

                public void onThrowable(Throwable t) {
                    Assert.fail((String)"Got throwable.", (Throwable)t);
                    err.set(true);
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart e) throws Exception {
                    if (e.length() != 0) {
                        String s = new String(e.getBodyPartBytes());
                        AsyncStreamLifecycleTest.this.logger.info("got part: {}", (Object)s);
                        queue.put(s);
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus e) {
                    status.set(true);
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders e) throws Exception {
                    if (headers.incrementAndGet() == 2) {
                        throw new Exception("Analyze this.");
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public Object onCompleted() {
                    latch.countDown();
                    return null;
                }
            });
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Latch failed.");
            Assert.assertFalse((boolean)err.get());
            Assert.assertEquals((int)queue.size(), (int)2);
            Assert.assertTrue((boolean)queue.contains("part1"));
            Assert.assertTrue((boolean)queue.contains("part2"));
            Assert.assertTrue((boolean)status.get());
            Assert.assertEquals((int)headers.get(), (int)1);
        }
    }
}

