/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.EchoHandler;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractBasicTest {
    protected static final int TIMEOUT = 30;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Server server;
    protected int port1 = -1;
    protected int port2 = -1;

    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.server);
        this.server.setHandler((Handler)this.configureHandler());
        ServerConnector connector2 = TestUtils.addHttpConnector(this.server);
        this.server.start();
        this.port1 = connector1.getLocalPort();
        this.port2 = connector2.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected String getTargetUrl() {
        return String.format("http://localhost:%d/foo/test", this.port1);
    }

    protected String getTargetUrl2() {
        return String.format("https://localhost:%d/foo/test", this.port2);
    }

    public AbstractHandler configureHandler() throws Exception {
        return new EchoHandler();
    }

    public static class AsyncCompletionHandlerAdapter
    extends AsyncCompletionHandler<Response> {
        public Response onCompleted(Response response) throws Exception {
            return response;
        }

        public void onThrowable(Throwable t) {
            t.printStackTrace();
        }
    }
}

