/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.server.ServerTestHelper;
import org.apache.hive.druid.org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class HashBasedNumberedShardSpecTest {
    @Test
    public void testSerdeRoundTrip() throws Exception {
        ShardSpec spec = (ShardSpec)ServerTestHelper.MAPPER.readValue(ServerTestHelper.MAPPER.writeValueAsBytes((Object)new HashBasedNumberedShardSpec(1, 2, (List)ImmutableList.of((Object)"visitor_id"), ServerTestHelper.MAPPER)), ShardSpec.class);
        Assert.assertEquals((long)1L, (long)spec.getPartitionNum());
        Assert.assertEquals((long)2L, (long)((HashBasedNumberedShardSpec)spec).getPartitions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"visitor_id"), (Object)((HashBasedNumberedShardSpec)spec).getPartitionDimensions());
    }

    @Test
    public void testSerdeBackwardsCompat() throws Exception {
        ShardSpec spec = (ShardSpec)ServerTestHelper.MAPPER.readValue("{\"type\": \"hashed\", \"partitions\": 2, \"partitionNum\": 1}", ShardSpec.class);
        Assert.assertEquals((long)1L, (long)spec.getPartitionNum());
        Assert.assertEquals((long)2L, (long)((HashBasedNumberedShardSpec)spec).getPartitions());
        ShardSpec specWithPartitionDimensions = (ShardSpec)ServerTestHelper.MAPPER.readValue("{\"type\": \"hashed\", \"partitions\": 2, \"partitionNum\": 1, \"partitionDimensions\":[\"visitor_id\"]}", ShardSpec.class);
        Assert.assertEquals((long)1L, (long)specWithPartitionDimensions.getPartitionNum());
        Assert.assertEquals((long)2L, (long)((HashBasedNumberedShardSpec)specWithPartitionDimensions).getPartitions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"visitor_id"), (Object)((HashBasedNumberedShardSpec)specWithPartitionDimensions).getPartitionDimensions());
    }

    @Test
    public void testPartitionChunks() {
        ImmutableList specs = ImmutableList.of((Object)new HashBasedNumberedShardSpec(0, 3, null, ServerTestHelper.MAPPER), (Object)new HashBasedNumberedShardSpec(1, 3, null, ServerTestHelper.MAPPER), (Object)new HashBasedNumberedShardSpec(2, 3, null, ServerTestHelper.MAPPER));
        List chunks = Lists.transform((List)specs, (Function)new Function<ShardSpec, PartitionChunk<String>>(){

            public PartitionChunk<String> apply(ShardSpec shardSpec) {
                return shardSpec.createChunk((Object)"rofl");
            }
        });
        Assert.assertEquals((long)0L, (long)((PartitionChunk)chunks.get(0)).getChunkNumber());
        Assert.assertEquals((long)1L, (long)((PartitionChunk)chunks.get(1)).getChunkNumber());
        Assert.assertEquals((long)2L, (long)((PartitionChunk)chunks.get(2)).getChunkNumber());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(0)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).isEnd());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).isEnd());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(2)).isEnd());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(2)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(2)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(2)));
    }

    @Test
    public void testIsInChunk() {
        ArrayList<ShardSpec> specs = new ArrayList<ShardSpec>();
        for (int i = 0; i < 3; ++i) {
            specs.add((ShardSpec)new HashOverridenShardSpec(i, 3));
        }
        this.assertExistsInOneSpec(specs, new HashInputRow(Integer.MIN_VALUE));
        this.assertExistsInOneSpec(specs, new HashInputRow(Integer.MAX_VALUE));
        this.assertExistsInOneSpec(specs, new HashInputRow(0));
        this.assertExistsInOneSpec(specs, new HashInputRow(1000));
        this.assertExistsInOneSpec(specs, new HashInputRow(-1000));
    }

    @Test
    public void testGetGroupKey() {
        HashBasedNumberedShardSpec shardSpec1 = new HashBasedNumberedShardSpec(1, 2, (List)ImmutableList.of((Object)"visitor_id"), ServerTestHelper.MAPPER);
        DateTime time = DateTimes.nowUtc();
        MapBasedInputRow inputRow = new MapBasedInputRow(time, (List)ImmutableList.of((Object)"visitor_id", (Object)"cnt"), (Map)ImmutableMap.of((Object)"visitor_id", (Object)"v1", (Object)"cnt", (Object)10));
        Assert.assertEquals((Object)ImmutableList.of(Collections.singletonList("v1")), (Object)shardSpec1.getGroupKey(time.getMillis(), (InputRow)inputRow));
        HashBasedNumberedShardSpec shardSpec2 = new HashBasedNumberedShardSpec(1, 2, null, ServerTestHelper.MAPPER);
        Assert.assertEquals((Object)ImmutableList.of((Object)time.getMillis(), (Object)ImmutableMap.of((Object)"cnt", Collections.singletonList(10), (Object)"visitor_id", Collections.singletonList("v1"))).toString(), (Object)shardSpec2.getGroupKey(time.getMillis(), (InputRow)inputRow).toString());
    }

    public boolean assertExistsInOneSpec(List<ShardSpec> specs, InputRow row) {
        for (ShardSpec spec : specs) {
            if (!spec.isInChunk(row.getTimestampFromEpoch(), row)) continue;
            return true;
        }
        throw new ISE("None of the partition matches", new Object[0]);
    }

    public static class HashInputRow
    implements InputRow {
        private final int hashcode;

        HashInputRow(int hashcode) {
            this.hashcode = hashcode;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public List<String> getDimensions() {
            return null;
        }

        public long getTimestampFromEpoch() {
            return 0L;
        }

        public DateTime getTimestamp() {
            return DateTimes.EPOCH;
        }

        public List<String> getDimension(String s) {
            return null;
        }

        public Object getRaw(String s) {
            return null;
        }

        public Number getMetric(String metric) {
            return 0;
        }

        public int compareTo(Row o) {
            return 0;
        }
    }

    public static class HashOverridenShardSpec
    extends HashBasedNumberedShardSpec {
        public HashOverridenShardSpec(int partitionNum, int partitions) {
            super(partitionNum, partitions, null, ServerTestHelper.MAPPER);
        }

        protected int hash(long timestamp, InputRow inputRow) {
            return inputRow.hashCode();
        }
    }
}

