/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedOverwritingPartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.OvershadowableInteger;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionHolder;
import org.apache.hive.druid.org.apache.druid.timeline.partition.SingleElementPartitionChunk;
import org.joda.time.Interval;
import org.junit.Assert;

public class VersionedIntervalTimelineTestBase {
    VersionedIntervalTimeline<String, OvershadowableInteger> timeline;

    static void assertValues(List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>> expected, List<TimelineObjectHolder<String, OvershadowableInteger>> actual) {
        Assert.assertEquals((String)"Sizes did not match.", (long)expected.size(), (long)actual.size());
        Iterator<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>> expectedIter = expected.iterator();
        Iterator<TimelineObjectHolder<String, OvershadowableInteger>> actualIter = actual.iterator();
        while (expectedIter.hasNext()) {
            Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>> pair = expectedIter.next();
            TimelineObjectHolder<String, OvershadowableInteger> holder = actualIter.next();
            Assert.assertEquals((Object)pair.lhs, (Object)holder.getInterval());
            Assert.assertEquals((Object)((Pair)pair.rhs).lhs, (Object)holder.getVersion());
            ArrayList expectedChunks = Lists.newArrayList((Iterable)((Iterable)((Pair)pair.rhs).rhs));
            ArrayList actualChunks = Lists.newArrayList((Iterable)holder.getObject());
            Assert.assertEquals((long)expectedChunks.size(), (long)actualChunks.size());
            for (int i = 0; i < expectedChunks.size(); ++i) {
                Assert.assertEquals(expectedChunks.get(i), actualChunks.get(i));
                OvershadowableInteger expectedInteger = (OvershadowableInteger)((PartitionChunk)expectedChunks.get(i)).getObject();
                OvershadowableInteger actualInteger = (OvershadowableInteger)((PartitionChunk)actualChunks.get(i)).getObject();
                Assert.assertEquals((Object)expectedInteger, (Object)actualInteger);
            }
        }
    }

    static void assertValues(Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>> expected, Set<TimelineObjectHolder<String, OvershadowableInteger>> actual) {
        Assert.assertEquals((String)"Sizes did not match.", (long)expected.size(), (long)actual.size());
        HashSet actualSet = Sets.newHashSet((Iterable)Iterables.transform(actual, input -> new Pair((Object)input.getInterval(), (Object)new Pair(input.getVersion(), (Object)input.getObject()))));
        Assert.assertEquals(expected, (Object)actualSet);
    }

    static VersionedIntervalTimeline<String, OvershadowableInteger> makeStringIntegerTimeline() {
        return new VersionedIntervalTimeline((Comparator)Ordering.natural());
    }

    void checkRemove() {
        for (TimelineObjectHolder holder : this.timeline.findFullyOvershadowed()) {
            for (PartitionChunk chunk : holder.getObject()) {
                this.timeline.remove(holder.getInterval(), holder.getVersion(), chunk);
            }
        }
        Assert.assertTrue((boolean)this.timeline.findFullyOvershadowed().isEmpty());
    }

    TimelineObjectHolder<String, OvershadowableInteger> makeTimelineObjectHolder(String interval, String version, List<PartitionChunk<OvershadowableInteger>> chunks) {
        return new TimelineObjectHolder(Intervals.of((String)interval), Intervals.of((String)interval), (Object)version, new PartitionHolder(chunks));
    }

    Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>> createExpected(String intervalString, String version, Integer value) {
        return this.createExpected(intervalString, version, Collections.singletonList(this.makeSingle(version, value)));
    }

    Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>> createExpected(String intervalString, String version, List<PartitionChunk<OvershadowableInteger>> values) {
        return Pair.of((Object)Intervals.of((String)intervalString), (Object)Pair.of((Object)version, (Object)new PartitionHolder(values)));
    }

    PartitionChunk<OvershadowableInteger> makeSingle(String majorVersion, int value) {
        return this.makeSingle(majorVersion, 0, value);
    }

    private PartitionChunk<OvershadowableInteger> makeSingle(String majorVersion, int partitionNum, int val) {
        return new SingleElementPartitionChunk((Object)new OvershadowableInteger(majorVersion, partitionNum, val));
    }

    PartitionChunk<OvershadowableInteger> makeNumbered(String majorVersion, int partitionNum, int val) {
        return new NumberedPartitionChunk(partitionNum, 0, (Object)new OvershadowableInteger(majorVersion, partitionNum, val));
    }

    PartitionChunk<OvershadowableInteger> makeNumberedOverwriting(String majorVersion, int partitionNumOrdinal, int val, int startRootPartitionId, int endRootPartitionId, int minorVersion, int atomicUpdateGroupSize) {
        int partitionNum = 32768 + partitionNumOrdinal;
        return new NumberedOverwritingPartitionChunk(partitionNum, (Object)new OvershadowableInteger(majorVersion, partitionNum, val, startRootPartitionId, endRootPartitionId, minorVersion, atomicUpdateGroupSize));
    }

    void add(String interval, String version, Integer value) {
        this.add(Intervals.of((String)interval), version, value);
    }

    void add(Interval interval, String version, Integer value) {
        this.add(interval, version, this.makeSingle(version, value));
    }

    void add(String interval, String version, PartitionChunk<OvershadowableInteger> value) {
        this.add(Intervals.of((String)interval), version, value);
    }

    protected void add(Interval interval, String version, PartitionChunk<OvershadowableInteger> value) {
        this.timeline.add(interval, (Object)version, value);
    }
}

