/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.timeline.Overshadowable;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimelineTestBase;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ImmutablePartitionHolder;
import org.apache.hive.druid.org.apache.druid.timeline.partition.IntegerPartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.OvershadowableInteger;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersionedIntervalTimelineSpecificDataTest
extends VersionedIntervalTimelineTestBase {
    @Before
    public void setUp() {
        this.timeline = VersionedIntervalTimelineSpecificDataTest.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-03", "1", (Integer)2);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        this.add("2011-04-06/2011-04-09", "3", (Integer)4);
        this.add("2011-04-01/2011-04-02", "3", (Integer)5);
        this.add("2011-05-01/2011-05-02", "1", (Integer)6);
        this.add("2011-05-01/2011-05-05", "2", (Integer)7);
        this.add("2011-05-03/2011-05-04", "3", (Integer)8);
        this.add("2011-05-01/2011-05-10", "4", (Integer)9);
        this.add("2011-10-01/2011-10-02", "1", (Integer)1);
        this.add("2011-10-02/2011-10-03", "3", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Overshadowable)new OvershadowableInteger("3", 0, 20)));
        this.add("2011-10-02/2011-10-03", "3", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make((Integer)10, null, (int)1, (Overshadowable)new OvershadowableInteger("3", 1, 21)));
        this.add("2011-10-03/2011-10-04", "3", (Integer)3);
        this.add("2011-10-04/2011-10-05", "4", (Integer)4);
        this.add("2011-10-05/2011-10-06", "5", (Integer)5);
    }

    @Test
    public void testApril() {
        VersionedIntervalTimelineSpecificDataTest.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-02/2011-04-06", "2", 1), this.createExpected("2011-04-06/2011-04-09", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
    }

    @Test
    public void testApril2() {
        Assert.assertEquals(this.makeSingle("2", 1), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"2", this.makeSingle("2", 1)));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-02/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
    }

    @Test
    public void testApril3() {
        Assert.assertEquals(this.makeSingle("2", 1), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"2", this.makeSingle("2", 1)));
        Assert.assertEquals(this.makeSingle("1", 2), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-03"), (Object)"1", this.makeSingle("1", 2)));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
    }

    @Test
    public void testApril4() {
        Assert.assertEquals(this.makeSingle("2", 1), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"2", this.makeSingle("2", 1)));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-02/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-05", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-05")));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Arrays.asList(this.createExpected("2011-04-02T18/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-04T01", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-04-02T18/2011-04-04T01")));
    }

    @Test
    public void testMay() {
        VersionedIntervalTimelineSpecificDataTest.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "4", 9)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test
    public void testMay2() {
        Assert.assertNotNull((Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"4", this.makeSingle("4", 9)));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Arrays.asList(this.createExpected("2011-05-01/2011-05-03", "2", 7), this.createExpected("2011-05-03/2011-05-04", "3", 8), this.createExpected("2011-05-04/2011-05-05", "2", 7)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test
    public void testMay3() {
        Assert.assertEquals(this.makeSingle("4", 9), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"4", this.makeSingle("4", 9)));
        Assert.assertEquals(this.makeSingle("2", 7), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-05"), (Object)"2", this.makeSingle("2", 7)));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Arrays.asList(this.createExpected("2011-05-01/2011-05-02", "1", 6), this.createExpected("2011-05-03/2011-05-04", "3", 8)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test
    public void testInsertInWrongOrder() {
        DateTime overallStart = DateTimes.nowUtc().minus((ReadablePeriod)Hours.TWO);
        Assert.assertTrue((String)"These timestamps have to be at the end AND include now for this test to work.", (boolean)overallStart.isAfter((ReadableInstant)((Interval)this.timeline.incompletePartitionsTimeline.lastEntry().getKey()).getEnd()));
        Interval oneHourInterval1 = new Interval((ReadableInstant)overallStart.plus((ReadablePeriod)Hours.THREE), (ReadableInstant)overallStart.plus((ReadablePeriod)Hours.FOUR));
        Interval oneHourInterval2 = new Interval((ReadableInstant)overallStart.plus((ReadablePeriod)Hours.FOUR), (ReadableInstant)overallStart.plus((ReadablePeriod)Hours.FIVE));
        this.add(oneHourInterval1, "1", (Integer)1);
        this.add(oneHourInterval2, "1", (Integer)1);
        this.add(new Interval((ReadableInstant)overallStart, (ReadableInstant)overallStart.plus((ReadablePeriod)Days.ONE)), "2", (Integer)2);
        VersionedIntervalTimelineSpecificDataTest.assertValues(Collections.singletonList(this.createExpected(oneHourInterval1.toString(), "2", 2)), this.timeline.lookup(oneHourInterval1));
    }

    @Test
    public void testRemove() {
        this.checkRemove();
    }

    @Test
    public void testFindEntry() {
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle("1", 1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01/2011-10-02"), (Object)"1"));
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle("1", 1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01/2011-10-01T10"), (Object)"1"));
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle("1", 1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T02/2011-10-02"), (Object)"1"));
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle("1", 1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T04/2011-10-01T17"), (Object)"1"));
        Assert.assertEquals(null, (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T04/2011-10-01T17"), (Object)"2"));
        Assert.assertEquals(null, (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T04/2011-10-02T17"), (Object)"1"));
    }

    @Test
    public void testPartitioning() {
        VersionedIntervalTimelineSpecificDataTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-10-01/2011-10-02", "1", 1), this.createExpected("2011-10-02/2011-10-03", "3", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Overshadowable)new OvershadowableInteger("3", 0, 20)), IntegerPartitionChunk.make((Integer)10, null, (int)1, (Overshadowable)new OvershadowableInteger("3", 1, 21)))), this.createExpected("2011-10-03/2011-10-04", "3", 3), this.createExpected("2011-10-04/2011-10-05", "4", 4), this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-01/2011-10-06")));
    }

    @Test
    public void testPartialPartitionNotReturned() {
        this.testRemove();
        this.add("2011-10-06/2011-10-07", "6", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Overshadowable)new OvershadowableInteger("6", 0, 60)));
        VersionedIntervalTimelineSpecificDataTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findFullyOvershadowed().isEmpty());
        this.add("2011-10-06/2011-10-07", "6", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make((Integer)10, (Integer)20, (int)1, (Overshadowable)new OvershadowableInteger("6", 1, 61)));
        VersionedIntervalTimelineSpecificDataTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findFullyOvershadowed().isEmpty());
        this.add("2011-10-06/2011-10-07", "6", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make((Integer)20, null, (int)2, (Overshadowable)new OvershadowableInteger("6", 2, 62)));
        VersionedIntervalTimelineSpecificDataTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5), this.createExpected("2011-10-06/2011-10-07", "6", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Overshadowable)new OvershadowableInteger("6", 0, 60)), IntegerPartitionChunk.make((Integer)10, (Integer)20, (int)1, (Overshadowable)new OvershadowableInteger("6", 1, 61)), IntegerPartitionChunk.make((Integer)20, null, (int)2, (Overshadowable)new OvershadowableInteger("6", 2, 62))))), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findFullyOvershadowed().isEmpty());
    }

    @Test
    public void testIncompletePartitionDoesNotOvershadow() {
        this.testRemove();
        this.add("2011-10-05/2011-10-07", "6", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Overshadowable)new OvershadowableInteger("6", 0, 60)));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findFullyOvershadowed().isEmpty());
        this.add("2011-10-05/2011-10-07", "6", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make((Integer)10, (Integer)20, (int)1, (Overshadowable)new OvershadowableInteger("6", 1, 61)));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findFullyOvershadowed().isEmpty());
        this.add("2011-10-05/2011-10-07", "6", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make((Integer)20, null, (int)2, (Overshadowable)new OvershadowableInteger("6", 2, 62)));
        VersionedIntervalTimelineSpecificDataTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testRemovePartitionMakesIncomplete() {
        this.testIncompletePartitionDoesNotOvershadow();
        IntegerPartitionChunk chunk = IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Overshadowable)new OvershadowableInteger("6", 0, 60));
        Assert.assertEquals((Object)chunk, (Object)this.timeline.remove(Intervals.of((String)"2011-10-05/2011-10-07"), (Object)"6", (PartitionChunk)chunk));
        VersionedIntervalTimelineSpecificDataTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findFullyOvershadowed().isEmpty());
    }

    @Test
    public void testInsertAndRemoveSameThingsion() {
        this.add("2011-05-01/2011-05-10", "5", (Integer)10);
        VersionedIntervalTimelineSpecificDataTest.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "5", 10)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
        Assert.assertEquals(this.makeSingle("5", 10), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"5", this.makeSingle("5", 10)));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "4", 9)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
        this.add("2011-05-01/2011-05-10", "5", (Integer)10);
        VersionedIntervalTimelineSpecificDataTest.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "5", 10)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
        Assert.assertEquals(this.makeSingle("4", 9), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"4", this.makeSingle("4", 9)));
        VersionedIntervalTimelineSpecificDataTest.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "5", 10)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test
    public void testRemoveSomethingDontHave() {
        Assert.assertNull((String)"Don't have it, should be null", (Object)this.timeline.remove(Intervals.of((String)"1970-01-01/2025-04-20"), (Object)"1", this.makeSingle("1", 1)));
        Assert.assertNull((String)"Don't have it, should be null", (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"version does not exist", this.makeSingle("version does not exist", 1)));
    }
}

