/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline;

import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.TestObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentWithOvershadowedStatus;
import org.apache.hive.druid.org.apache.druid.timeline.TestSegmentWithOvershadowedStatus;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SegmentWithOvershadowedStatusTest {
    private static final ObjectMapper MAPPER = SegmentWithOvershadowedStatusTest.createObjectMapper();
    private static final Interval INTERVAL = Intervals.of((String)"2011-10-01/2011-10-02");
    private static final ImmutableMap<String, Object> LOAD_SPEC = ImmutableMap.of((Object)"something", (Object)"or_other");
    private static final boolean OVERSHADOWED = true;
    private static final int TEST_VERSION = 9;
    private static final SegmentWithOvershadowedStatus SEGMENT = SegmentWithOvershadowedStatusTest.createSegmentWithOvershadowedStatus();

    private static ObjectMapper createObjectMapper() {
        TestObjectMapper objectMapper = new TestObjectMapper();
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT);
        objectMapper.setInjectableValues((InjectableValues)injectableValues);
        return objectMapper;
    }

    private static SegmentWithOvershadowedStatus createSegmentWithOvershadowedStatus() {
        DataSegment dataSegment = new DataSegment("something", INTERVAL, "1", LOAD_SPEC, Arrays.asList("dim1", "dim2"), Arrays.asList("met1", "met2"), (ShardSpec)NoneShardSpec.instance(), null, Integer.valueOf(9), 1L);
        return new SegmentWithOvershadowedStatus(dataSegment, true);
    }

    @Test
    public void testUnwrappedSegmentWithOvershadowedStatusDeserialization() throws Exception {
        Map objectMap = (Map)MAPPER.readValue(MAPPER.writeValueAsString((Object)SEGMENT), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)11L, (long)objectMap.size());
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)INTERVAL.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals(LOAD_SPEC, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"none"), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
        Assert.assertEquals((Object)true, objectMap.get("overshadowed"));
        String json = MAPPER.writeValueAsString((Object)SEGMENT);
        TestSegmentWithOvershadowedStatus deserializedSegment = (TestSegmentWithOvershadowedStatus)((Object)MAPPER.readValue(json, TestSegmentWithOvershadowedStatus.class));
        DataSegment dataSegment = SEGMENT.getDataSegment();
        Assert.assertEquals((Object)dataSegment.getDataSource(), (Object)deserializedSegment.getDataSource());
        Assert.assertEquals((Object)dataSegment.getInterval(), (Object)deserializedSegment.getInterval());
        Assert.assertEquals((Object)dataSegment.getVersion(), (Object)deserializedSegment.getVersion());
        Assert.assertEquals((Object)dataSegment.getLoadSpec(), (Object)deserializedSegment.getLoadSpec());
        Assert.assertEquals((Object)dataSegment.getDimensions(), (Object)deserializedSegment.getDimensions());
        Assert.assertEquals((Object)dataSegment.getMetrics(), (Object)deserializedSegment.getMetrics());
        Assert.assertEquals((Object)dataSegment.getShardSpec(), (Object)deserializedSegment.getShardSpec());
        Assert.assertEquals((long)dataSegment.getSize(), (long)deserializedSegment.getSize());
        Assert.assertEquals((Object)dataSegment.getId(), (Object)deserializedSegment.getId());
    }

    @Test
    public void testJsonCreatorAndJsonUnwrappedAnnotationsAreCompatible() throws Exception {
        String json = MAPPER.writeValueAsString((Object)SEGMENT);
        SegmentWithOvershadowedStatus segment = (SegmentWithOvershadowedStatus)MAPPER.readValue(json, SegmentWithOvershadowedStatus.class);
        Assert.assertEquals((Object)SEGMENT, (Object)segment);
        Assert.assertEquals((Object)json, (Object)MAPPER.writeValueAsString((Object)segment));
    }
}

