/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class SegmentIdTest {
    @Test
    public void testBasic() {
        String datasource = "datasource";
        SegmentId desc = SegmentId.of((String)datasource, (Interval)Intervals.of((String)"2015-01-02/2015-01-03"), (String)"ver_0", (int)1);
        Assert.assertEquals((Object)"datasource_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0_1", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
        desc = desc.withInterval(Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        Assert.assertEquals((Object)"datasource_2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z_ver_0_1", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
        desc = SegmentId.of((String)datasource, (Interval)Intervals.of((String)"2015-01-02/2015-01-03"), (String)"ver", (int)0);
        Assert.assertEquals((Object)"datasource_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
        desc = desc.withInterval(Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        Assert.assertEquals((Object)"datasource_2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z_ver", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
    }

    @Test
    public void testDataSourceWithUnderscore() {
        String datasource = "datasource_1";
        SegmentId desc = SegmentId.of((String)datasource, (Interval)Intervals.of((String)"2015-01-02/2015-01-03"), (String)"ver_0", (int)1);
        Assert.assertEquals((Object)"datasource_1_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0_1", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
        desc = desc.withInterval(Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        Assert.assertEquals((Object)"datasource_1_2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z_ver_0_1", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
        desc = SegmentId.of((String)datasource, (Interval)Intervals.of((String)"2015-01-02/2015-01-03"), (String)"ver", (int)0);
        Assert.assertEquals((Object)"datasource_1_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
        desc = desc.withInterval(Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        Assert.assertEquals((Object)"datasource_1_2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z_ver", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)datasource, (String)desc.toString()));
    }

    @Test
    public void testDataSourceWithUnderscoreAndTimeStringInDataSourceName() {
        String dataSource = "datasource_2015-01-01T00:00:00.000Z";
        SegmentId desc = SegmentId.of((String)dataSource, (Interval)Intervals.of((String)"2015-01-02/2015-01-03"), (String)"ver_0", (int)1);
        Assert.assertEquals((Object)"datasource_2015-01-01T00:00:00.000Z_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0_1", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)dataSource, (String)desc.toString()));
        desc = desc.withInterval(Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        Assert.assertEquals((Object)"datasource_2015-01-01T00:00:00.000Z_2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z_ver_0_1", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)dataSource, (String)desc.toString()));
        desc = SegmentId.of((String)dataSource, (Interval)Intervals.of((String)"2015-01-02/2015-01-03"), (String)"ver", (int)0);
        Assert.assertEquals((Object)"datasource_2015-01-01T00:00:00.000Z_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)dataSource, (String)desc.toString()));
        desc = desc.withInterval(Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        Assert.assertEquals((Object)"datasource_2015-01-01T00:00:00.000Z_2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z_ver", (Object)desc.toString());
        Assert.assertEquals((Object)desc, (Object)SegmentId.tryParse((String)dataSource, (String)desc.toString()));
    }

    @Test
    public void testInvalidFormat0() {
        Assert.assertNull((Object)SegmentId.tryParse((String)"datasource", (String)"datasource_2015-01-02T00:00:00.000Z_2014-10-20T00:00:00.000Z_version"));
    }

    @Test
    public void testInvalidFormat1() {
        Assert.assertNull((Object)SegmentId.tryParse((String)"datasource", (String)"datasource_invalid_interval_version"));
    }

    @Test
    public void testInvalidFormat2() {
        Assert.assertNull((Object)SegmentId.tryParse((String)"datasource", (String)"datasource_2015-01-02T00:00:00.000Z_version"));
    }

    @Test
    public void testTryParseHeuristically() {
        List<String> segmentIds = Arrays.asList("datasource_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0_1", "datasource_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver", "datasource_1_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0_1", "datasource_1_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver", "datasource_2015-01-01T00:00:00.000Z_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0_1", "datasource_2015-01-01T00:00:00.000Z_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver");
        for (String segmentId : segmentIds) {
            String dataSource = SegmentId.tryExtractMostProbableDataSource((String)segmentId);
            Assert.assertTrue(("datasource".equals(dataSource) || "datasource_1".equals(dataSource) ? 1 : 0) != 0);
            Assert.assertTrue((!SegmentId.iteratePossibleParsingsWithDataSource((String)dataSource, (String)segmentId).isEmpty() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTryParseVersionAmbiguity() {
        SegmentId segmentId = SegmentId.tryParse((String)"datasource", (String)"datasource_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0");
        Assert.assertNotNull((Object)segmentId);
        Assert.assertEquals((Object)"ver_0", (Object)segmentId.getVersion());
        Assert.assertEquals((long)0L, (long)segmentId.getPartitionNum());
    }

    @Test
    public void testIterateAllPossibleParsings() {
        String segmentId = "datasource_2015-01-01T00:00:00.000Z_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_ver_0_1";
        ImmutableList possibleParsings = ImmutableList.copyOf((Iterable)SegmentId.iterateAllPossibleParsings((String)segmentId));
        DateTime dt1 = DateTimes.of((String)"2015-01-01T00:00:00.000Z");
        DateTime dt2 = DateTimes.of((String)"2015-01-02T00:00:00.000Z");
        DateTime dt3 = DateTimes.of((String)"2015-01-03T00:00:00.000Z");
        ImmutableSet expected = ImmutableSet.of((Object)SegmentId.of((String)"datasource", (Interval)new Interval((ReadableInstant)dt1, (ReadableInstant)dt2), (String)"2015-01-03T00:00:00.000Z_ver_0", (int)1), (Object)SegmentId.of((String)"datasource", (Interval)new Interval((ReadableInstant)dt1, (ReadableInstant)dt2), (String)"2015-01-03T00:00:00.000Z_ver_0_1", (int)0), (Object)SegmentId.of((String)"datasource_2015-01-01T00:00:00.000Z", (Interval)new Interval((ReadableInstant)dt2, (ReadableInstant)dt3), (String)"ver_0", (int)1), (Object)SegmentId.of((String)"datasource_2015-01-01T00:00:00.000Z", (Interval)new Interval((ReadableInstant)dt2, (ReadableInstant)dt3), (String)"ver_0_1", (int)0));
        Assert.assertEquals((long)4L, (long)possibleParsings.size());
        Assert.assertEquals((Object)expected, (Object)ImmutableSet.copyOf((Collection)possibleParsings));
    }

    @Test
    public void testIterateAllPossibleParsingsWithEmptyVersion() {
        String segmentId = "datasource_2015-01-01T00:00:00.000Z_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z__1";
        ImmutableList possibleParsings = ImmutableList.copyOf((Iterable)SegmentId.iterateAllPossibleParsings((String)segmentId));
        DateTime dt1 = DateTimes.of((String)"2015-01-01T00:00:00.000Z");
        DateTime dt2 = DateTimes.of((String)"2015-01-02T00:00:00.000Z");
        DateTime dt3 = DateTimes.of((String)"2015-01-03T00:00:00.000Z");
        ImmutableSet expected = ImmutableSet.of((Object)SegmentId.of((String)"datasource", (Interval)new Interval((ReadableInstant)dt1, (ReadableInstant)dt2), (String)"2015-01-03T00:00:00.000Z_", (int)1), (Object)SegmentId.of((String)"datasource", (Interval)new Interval((ReadableInstant)dt1, (ReadableInstant)dt2), (String)"2015-01-03T00:00:00.000Z__1", (int)0), (Object)SegmentId.of((String)"datasource_2015-01-01T00:00:00.000Z", (Interval)new Interval((ReadableInstant)dt2, (ReadableInstant)dt3), (String)"", (int)1), (Object)SegmentId.of((String)"datasource_2015-01-01T00:00:00.000Z", (Interval)new Interval((ReadableInstant)dt2, (ReadableInstant)dt3), (String)"_1", (int)0));
        Assert.assertEquals((long)4L, (long)possibleParsings.size());
        Assert.assertEquals((Object)expected, (Object)ImmutableSet.copyOf((Collection)possibleParsings));
    }

    @Test
    public void testIterateAllPossibleParsings2() {
        String segmentId = "datasource_2015-01-02T00:00:00.000Z_2015-01-03T00:00:00.000Z_2015-01-02T00:00:00.000Z_ver_1";
        ImmutableList possibleParsings = ImmutableList.copyOf((Iterable)SegmentId.iterateAllPossibleParsings((String)segmentId));
        DateTime dt1 = DateTimes.of((String)"2015-01-02T00:00:00.000Z");
        DateTime dt2 = DateTimes.of((String)"2015-01-03T00:00:00.000Z");
        ImmutableSet expected = ImmutableSet.of((Object)SegmentId.of((String)"datasource", (Interval)new Interval((ReadableInstant)dt1, (ReadableInstant)dt2), (String)"2015-01-02T00:00:00.000Z_ver", (int)1), (Object)SegmentId.of((String)"datasource", (Interval)new Interval((ReadableInstant)dt1, (ReadableInstant)dt2), (String)"2015-01-02T00:00:00.000Z_ver_1", (int)0));
        Assert.assertEquals((long)2L, (long)possibleParsings.size());
        Assert.assertEquals((Object)expected, (Object)ImmutableSet.copyOf((Collection)possibleParsings));
    }
}

