/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.TestObjectMapper;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.timeline.CompactionState;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecLookup;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSegmentTest {
    private static final ObjectMapper MAPPER = new TestObjectMapper();
    private static final int TEST_VERSION = 9;

    private static ShardSpec getShardSpec(final int partitionNum) {
        return new ShardSpec(){

            public <T> PartitionChunk<T> createChunk(T obj) {
                return null;
            }

            public boolean isInChunk(long timestamp, InputRow inputRow) {
                return false;
            }

            public int getPartitionNum() {
                return partitionNum;
            }

            public ShardSpecLookup getLookup(List<ShardSpec> shardSpecs) {
                return null;
            }

            public List<String> getDomainDimensions() {
                return ImmutableList.of();
            }

            public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
                return true;
            }

            public boolean isCompatible(Class<? extends ShardSpec> other) {
                return false;
            }
        };
    }

    @Before
    public void setUp() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT);
        MAPPER.setInjectableValues((InjectableValues)injectableValues);
    }

    @Test
    public void testV1Serialization() throws Exception {
        Interval interval = Intervals.of((String)"2011-10-01/2011-10-02");
        ImmutableMap loadSpec = ImmutableMap.of((Object)"something", (Object)"or_other");
        DataSegment segment = new DataSegment("something", interval, "1", (Map)loadSpec, Arrays.asList("dim1", "dim2"), Arrays.asList("met1", "met2"), (ShardSpec)new NumberedShardSpec(3, 0), new CompactionState((PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(100000), null, (List)ImmutableList.of((Object)"dim1")), (Map)ImmutableMap.of()), Integer.valueOf(9), 1L);
        Map objectMap = (Map)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)11L, (long)objectMap.size());
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)interval.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals((Object)loadSpec, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"numbered", (Object)"partitionNum", (Object)3, (Object)"partitions", (Object)0), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
        DataSegment deserializedSegment = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((Object)segment.getDataSource(), (Object)deserializedSegment.getDataSource());
        Assert.assertEquals((Object)segment.getInterval(), (Object)deserializedSegment.getInterval());
        Assert.assertEquals((Object)segment.getVersion(), (Object)deserializedSegment.getVersion());
        Assert.assertEquals((Object)segment.getLoadSpec(), (Object)deserializedSegment.getLoadSpec());
        Assert.assertEquals((Object)segment.getDimensions(), (Object)deserializedSegment.getDimensions());
        Assert.assertEquals((Object)segment.getMetrics(), (Object)deserializedSegment.getMetrics());
        Assert.assertEquals((Object)segment.getShardSpec(), (Object)deserializedSegment.getShardSpec());
        Assert.assertEquals((long)segment.getSize(), (long)deserializedSegment.getSize());
        Assert.assertEquals((Object)segment.getId(), (Object)deserializedSegment.getId());
        deserializedSegment = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((long)0L, (long)segment.compareTo(deserializedSegment));
        deserializedSegment = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((long)0L, (long)deserializedSegment.compareTo(segment));
        deserializedSegment = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((long)segment.hashCode(), (long)deserializedSegment.hashCode());
    }

    @Test
    public void testIdentifier() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)NoneShardSpec.instance()).size(0L).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z", (Object)segment.getId().toString());
    }

    @Test
    public void testIdentifierWithZeroPartition() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(0)).size(0L).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z", (Object)segment.getId().toString());
    }

    @Test
    public void testIdentifierWithNonzeroPartition() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec(DataSegmentTest.getShardSpec(7)).size(0L).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z_7", (Object)segment.getId().toString());
    }

    @Test
    public void testV1SerializationNullMetrics() throws Exception {
        DataSegment segment = this.makeDataSegment("foo", "2012-01-01/2012-01-02", DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString());
        DataSegment segment2 = (DataSegment)MAPPER.readValue(MAPPER.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((String)"empty dimensions", (Object)ImmutableList.of(), (Object)segment2.getDimensions());
        Assert.assertEquals((String)"empty metrics", (Object)ImmutableList.of(), (Object)segment2.getMetrics());
    }

    private DataSegment makeDataSegment(String dataSource, String interval, String version) {
        return DataSegment.builder().dataSource(dataSource).interval(Intervals.of((String)interval)).version(version).size(1L).build();
    }
}

