/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.testing.junit;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.rules.ExternalResource;

public class LoggerCaptureRule
extends ExternalResource {
    private final Class<?> targetClass;
    private InMemoryAppender inMemoryAppender;
    private LoggerConfig targetClassLoggerConfig;

    public LoggerCaptureRule(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    protected void before() {
        this.inMemoryAppender = new InMemoryAppender(this.targetClass);
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        this.targetClassLoggerConfig = configuration.getLoggerConfig(this.targetClass.getName());
        this.targetClassLoggerConfig.addAppender((Appender)this.inMemoryAppender, Level.ALL, null);
    }

    protected void after() {
        this.clearLogEvents();
        this.targetClassLoggerConfig.removeAppender(InMemoryAppender.NAME);
    }

    public List<LogEvent> getLogEvents() {
        return this.inMemoryAppender.getLogEvents();
    }

    public void clearLogEvents() {
        this.inMemoryAppender.clearLogEvents();
    }

    private static class InMemoryAppender
    extends AbstractAppender {
        static final String NAME = InMemoryAppender.class.getName();
        private final String targetLoggerName;
        private final CopyOnWriteArrayList<LogEvent> logEvents;

        InMemoryAppender(Class<?> targetClass) {
            super(NAME, null, null);
            this.targetLoggerName = targetClass.getName();
            this.logEvents = new CopyOnWriteArrayList();
        }

        public void append(LogEvent logEvent) {
            if (logEvent.getLoggerName().equals(this.targetLoggerName)) {
                this.logEvents.add(logEvent);
            }
        }

        List<LogEvent> getLogEvents() {
            return this.logEvents;
        }

        void clearLogEvents() {
            this.logEvents.clear();
        }
    }
}

