/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.testing;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

final class DeadlockDetectingFailOnTimeout
extends Statement {
    private final Statement originalStatement;
    private final TimeUnit timeUnit;
    private final long timeout;

    DeadlockDetectingFailOnTimeout(long timeout, TimeUnit timeoutUnit, Statement statement) {
        this.originalStatement = statement;
        this.timeout = timeout;
        this.timeUnit = timeoutUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        CallableStatement callable = new CallableStatement();
        FutureTask<Throwable> task = new FutureTask<Throwable>(callable);
        ThreadGroup threadGroup = new ThreadGroup("FailOnTimeoutGroup");
        Thread thread = new Thread(threadGroup, task, "Time-limited test");
        try {
            thread.setDaemon(true);
            thread.start();
            callable.awaitStarted();
            Throwable throwable = this.getResult(task, thread);
            if (throwable != null) {
                throw throwable;
            }
        }
        finally {
            try {
                thread.join(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                threadGroup.destroy();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
    }

    private Throwable getResult(FutureTask<Throwable> task, Thread thread) {
        try {
            if (this.timeout > 0L) {
                return task.get(this.timeout, this.timeUnit);
            }
            return task.get();
        }
        catch (InterruptedException e) {
            return e;
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
        catch (TimeoutException e) {
            return this.createTimeoutException(thread);
        }
    }

    private Exception createTimeoutException(Thread thread) {
        StackTraceElement[] stackTrace = thread.getStackTrace();
        TestTimedOutException currThreadException = new TestTimedOutException(this.timeout, this.timeUnit);
        if (stackTrace != null) {
            currThreadException.setStackTrace(stackTrace);
            thread.interrupt();
        }
        Exception stuckThreadException = this.getStuckThreadException(thread);
        Exception deadlockException = this.getDeadlockedThreadsException();
        if (stuckThreadException != null || deadlockException != null) {
            List exceptions = Stream.of(currThreadException, stuckThreadException, deadlockException).filter(Objects::nonNull).collect(Collectors.toList());
            return new MultipleFailureException(exceptions);
        }
        return currThreadException;
    }

    private StackTraceElement[] getStackTrace(Thread thread) {
        try {
            return thread.getStackTrace();
        }
        catch (SecurityException e) {
            return new StackTraceElement[0];
        }
    }

    @Nullable
    private Exception getStuckThreadException(Thread mainThread) {
        Thread stuckThread = this.getStuckThread(mainThread);
        if (stuckThread == null) {
            return null;
        }
        Exception stuckThreadException = new Exception("Appears to be stuck in thread " + stuckThread.getName());
        stuckThreadException.setStackTrace(this.getStackTrace(stuckThread));
        return stuckThreadException;
    }

    private Thread getStuckThread(Thread mainThread) {
        List<Thread> threadsInGroup = this.getThreadsInGroup(mainThread.getThreadGroup());
        if (threadsInGroup.isEmpty()) {
            return null;
        }
        Thread stuckThread = null;
        long maxCpuTime = 0L;
        for (Thread thread : threadsInGroup) {
            if (thread.getState() != Thread.State.RUNNABLE) continue;
            long threadCpuTime = this.cpuTime(thread);
            if (stuckThread != null && threadCpuTime <= maxCpuTime) continue;
            stuckThread = thread;
            maxCpuTime = threadCpuTime;
        }
        return stuckThread == mainThread ? null : stuckThread;
    }

    private List<Thread> getThreadsInGroup(ThreadGroup group) {
        int activeThreadCount = group.activeCount();
        int threadArraySize = Math.max(activeThreadCount * 2, 100);
        for (int loopCount = 0; loopCount < 5; ++loopCount) {
            Thread[] threads = new Thread[threadArraySize];
            int enumCount = group.enumerate(threads);
            if (enumCount < threadArraySize) {
                return Arrays.asList(threads).subList(0, enumCount);
            }
            threadArraySize += 100;
        }
        return Collections.emptyList();
    }

    private long cpuTime(Thread thr) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        if (mxBean.isThreadCpuTimeSupported()) {
            try {
                return mxBean.getThreadCpuTime(thr.getId());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return 0L;
    }

    @Nullable
    private Exception getDeadlockedThreadsException() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] deadlockedThreadIds = threadMXBean.findDeadlockedThreads();
        if (deadlockedThreadIds == null) {
            return null;
        }
        Exception deadlockException = new Exception("Deadlocked threads:");
        for (long deadlockedThreadId : deadlockedThreadIds) {
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(deadlockedThreadId);
            Exception threadException = new Exception(threadInfo.getThreadName() + " at " + threadInfo.getLockName());
            threadException.setStackTrace(threadInfo.getStackTrace());
            deadlockException.addSuppressed(threadException);
        }
        return deadlockException;
    }

    private class CallableStatement
    implements Callable<Throwable> {
        private final CountDownLatch startLatch = new CountDownLatch(1);

        private CallableStatement() {
        }

        @Override
        public Throwable call() throws Exception {
            try {
                this.startLatch.countDown();
                DeadlockDetectingFailOnTimeout.this.originalStatement.evaluate();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                return e;
            }
            return null;
        }

        public void awaitStarted() throws InterruptedException {
            this.startLatch.await();
        }
    }
}

