/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.shard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableRangeSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class SingleDimensionShardSpecTest {
    @Test
    public void testIsInChunk() {
        ImmutableMap tests = ImmutableMap.builder().put((Object)this.makeSpec(null, null), this.makeListOfPairs(true, null, true, "a", true, "h", true, "p", true, "y")).put((Object)this.makeSpec(null, "m"), this.makeListOfPairs(true, null, true, "a", true, "h", false, "p", false, "y")).put((Object)this.makeSpec("a", "h"), this.makeListOfPairs(false, null, true, "a", false, "h", false, "p", false, "y")).put((Object)this.makeSpec("d", "u"), this.makeListOfPairs(false, null, false, "a", true, "h", true, "p", false, "y")).put((Object)this.makeSpec("h", null), this.makeListOfPairs(false, null, false, "a", true, "h", true, "p", true, "y")).build();
        for (Map.Entry entry : tests.entrySet()) {
            SingleDimensionShardSpec spec = (SingleDimensionShardSpec)entry.getKey();
            for (Pair pair : (List)entry.getValue()) {
                MapBasedInputRow inputRow = new MapBasedInputRow(0L, (List)ImmutableList.of((Object)"billy"), Maps.transformValues((Map)((Map)pair.rhs), input -> input));
                Assert.assertEquals((String)StringUtils.format((String)"spec[%s], row[%s]", (Object[])new Object[]{spec, inputRow}), (Object)pair.lhs, (Object)spec.isInChunk(inputRow.getTimestampFromEpoch(), (InputRow)inputRow));
            }
        }
    }

    @Test
    public void testPossibleInDomain() {
        ImmutableMap domain1 = ImmutableMap.of((Object)"dim1", SingleDimensionShardSpecTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"abc")))));
        ImmutableMap domain2 = ImmutableMap.of((Object)"dim1", SingleDimensionShardSpecTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.singleton((Comparable)((Object)"e")))), (Object)"dim2", SingleDimensionShardSpecTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.singleton((Comparable)((Object)"na")))));
        SingleDimensionShardSpec shard1 = this.makeSpec("dim1", null, "abc");
        SingleDimensionShardSpec shard2 = this.makeSpec("dim1", "abc", "def");
        SingleDimensionShardSpec shard3 = this.makeSpec("dim1", "def", null);
        SingleDimensionShardSpec shard4 = this.makeSpec("dim2", null, "hello");
        SingleDimensionShardSpec shard5 = this.makeSpec("dim2", "hello", "jk");
        SingleDimensionShardSpec shard6 = this.makeSpec("dim2", "jk", "na");
        SingleDimensionShardSpec shard7 = this.makeSpec("dim2", "na", null);
        Assert.assertTrue((boolean)shard1.possibleInDomain((Map)domain1));
        Assert.assertFalse((boolean)shard2.possibleInDomain((Map)domain1));
        Assert.assertFalse((boolean)shard3.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard4.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard5.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard6.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard7.possibleInDomain((Map)domain1));
        Assert.assertFalse((boolean)shard1.possibleInDomain((Map)domain2));
        Assert.assertFalse((boolean)shard2.possibleInDomain((Map)domain2));
        Assert.assertTrue((boolean)shard3.possibleInDomain((Map)domain2));
        Assert.assertFalse((boolean)shard4.possibleInDomain((Map)domain2));
        Assert.assertFalse((boolean)shard5.possibleInDomain((Map)domain2));
        Assert.assertTrue((boolean)shard6.possibleInDomain((Map)domain2));
        Assert.assertTrue((boolean)shard7.possibleInDomain((Map)domain2));
    }

    private static RangeSet<String> rangeSet(List<Range<String>> ranges) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range<String> range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    private SingleDimensionShardSpec makeSpec(String start, String end) {
        return this.makeSpec("billy", start, end);
    }

    private SingleDimensionShardSpec makeSpec(String dimension, String start, String end) {
        return new SingleDimensionShardSpec(dimension, start, end, 0);
    }

    private Map<String, String> makeMap(String value) {
        return value == null ? ImmutableMap.of() : ImmutableMap.of((Object)"billy", (Object)value);
    }

    private List<Pair<Boolean, Map<String, String>>> makeListOfPairs(Object ... arguments) {
        Preconditions.checkState((arguments.length % 2 == 0 ? 1 : 0) != 0);
        ArrayList<Pair<Boolean, Map<String, String>>> retVal = new ArrayList<Pair<Boolean, Map<String, String>>>();
        for (int i = 0; i < arguments.length; i += 2) {
            retVal.add((Pair<Boolean, Map<String, String>>)Pair.of((Object)((Boolean)arguments[i]), this.makeMap((String)arguments[i + 1])));
        }
        return retVal;
    }
}

