/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.org.apache.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.org.apache.druid.server.security.TrustedDomainAuthenticator;
import org.easymock.EasyMock;
import org.junit.Test;

public class TrustedDomainAuthenticatorTest {
    @Test
    public void testTrustedHost() throws IOException, ServletException {
        TrustedDomainAuthenticator authenticator = new TrustedDomainAuthenticator("test-authenticator", "test.com", Boolean.valueOf(false), "my-auth", "myUser");
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"serverA.test.com");
        req.setAttribute("Druid-Authentication-Result", (Object)new AuthenticationResult("myUser", "my-auth", "test-authenticator", null));
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{req});
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        EasyMock.replay((Object[])new Object[]{resp});
        FilterChain filterChain = (FilterChain)EasyMock.createMock(FilterChain.class);
        filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{filterChain});
        Filter authenticatorFilter = authenticator.getFilter();
        authenticatorFilter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain});
    }

    @Test
    public void testNonTrustedHost() throws IOException, ServletException {
        TrustedDomainAuthenticator authenticator = new TrustedDomainAuthenticator("test-authenticator", "test.com", Boolean.valueOf(false), "my-auth", "myUser");
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"serverA.test2.com");
        EasyMock.replay((Object[])new Object[]{req});
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        EasyMock.replay((Object[])new Object[]{resp});
        FilterChain filterChain = (FilterChain)EasyMock.createMock(FilterChain.class);
        filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{filterChain});
        Filter authenticatorFilter = authenticator.getFilter();
        authenticatorFilter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain});
    }

    @Test
    public void testForwardedForTrustedHost() throws IOException, ServletException {
        TrustedDomainAuthenticator authenticator = new TrustedDomainAuthenticator("test-authenticator", "test.com", Boolean.valueOf(true), "my-auth", "myUser");
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"serverA.test2.com");
        EasyMock.expect((Object)req.getHeader("X-Forwarded-For")).andReturn((Object)"serverA.test.com");
        req.setAttribute("Druid-Authentication-Result", (Object)new AuthenticationResult("myUser", "my-auth", "test-authenticator", null));
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{req});
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        EasyMock.replay((Object[])new Object[]{resp});
        FilterChain filterChain = (FilterChain)EasyMock.createMock(FilterChain.class);
        filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{filterChain});
        Filter authenticatorFilter = authenticator.getFilter();
        authenticatorFilter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain});
    }

    @Test
    public void testForwardedForTrustedHostMultiProxy() throws IOException, ServletException {
        TrustedDomainAuthenticator authenticator = new TrustedDomainAuthenticator("test-authenticator", "test.com", Boolean.valueOf(true), "my-auth", "myUser");
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"serverA.test2.com");
        EasyMock.expect((Object)req.getHeader("X-Forwarded-For")).andReturn((Object)"serverA.test.com,proxy-1,proxy-2");
        req.setAttribute("Druid-Authentication-Result", (Object)new AuthenticationResult("myUser", "my-auth", "test-authenticator", null));
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{req});
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        EasyMock.replay((Object[])new Object[]{resp});
        FilterChain filterChain = (FilterChain)EasyMock.createMock(FilterChain.class);
        filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{filterChain});
        Filter authenticatorFilter = authenticator.getFilter();
        authenticatorFilter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain});
    }
}

