/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.router;

import java.util.Collections;
import org.apache.hive.druid.org.apache.druid.client.selector.Server;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.org.apache.druid.server.router.AvaticaConnectionBalancer;
import org.apache.hive.druid.org.apache.druid.server.router.QueryHostFinder;
import org.apache.hive.druid.org.apache.druid.server.router.RendezvousHashAvaticaConnectionBalancer;
import org.apache.hive.druid.org.apache.druid.server.router.TieredBrokerHostSelector;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryHostFinderTest {
    private TieredBrokerHostSelector brokerSelector;
    private Server server;

    @Before
    public void setUp() {
        this.brokerSelector = (TieredBrokerHostSelector)EasyMock.createMock(TieredBrokerHostSelector.class);
        this.server = new Server(){

            public String getScheme() {
                return null;
            }

            public String getHost() {
                return "foo";
            }

            public String getAddress() {
                return null;
            }

            public int getPort() {
                return 0;
            }
        };
        EasyMock.expect((Object)this.brokerSelector.select((Query)EasyMock.anyObject(Query.class))).andReturn((Object)Pair.of((Object)"service", (Object)this.server));
        EasyMock.replay((Object[])new Object[]{this.brokerSelector});
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.brokerSelector});
    }

    @Test
    public void testFindServer() {
        QueryHostFinder queryRunner = new QueryHostFinder(this.brokerSelector, (AvaticaConnectionBalancer)new RendezvousHashAvaticaConnectionBalancer());
        Server server = queryRunner.findServer((Query)new TimeBoundaryQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-08-31/2011-09-01"))), null, null, null));
        Assert.assertEquals((Object)"foo", (Object)server.getHost());
    }
}

