/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.metrics;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.hive.druid.org.apache.druid.server.metrics.TaskCountStatsMonitor;
import org.apache.hive.druid.org.apache.druid.server.metrics.TaskCountStatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskCountStatsMonitorTest {
    private TaskCountStatsProvider statsProvider;

    @Before
    public void setUp() {
        this.statsProvider = new TaskCountStatsProvider(){

            public Map<String, Long> getSuccessfulTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getFailedTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getRunningTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getPendingTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }

            public Map<String, Long> getWaitingTaskCount() {
                return ImmutableMap.of((Object)"d1", (Object)1L);
            }
        };
    }

    @Test
    public void testMonitor() {
        TaskCountStatsMonitor monitor = new TaskCountStatsMonitor(this.statsProvider);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)5L, (long)emitter.getEvents().size());
        Assert.assertEquals((Object)"task/success/count", emitter.getEvents().get(0).toMap().get("metric"));
        Assert.assertEquals((Object)1L, emitter.getEvents().get(0).toMap().get("value"));
        Assert.assertEquals((Object)"task/failed/count", emitter.getEvents().get(1).toMap().get("metric"));
        Assert.assertEquals((Object)1L, emitter.getEvents().get(1).toMap().get("value"));
        Assert.assertEquals((Object)"task/running/count", emitter.getEvents().get(2).toMap().get("metric"));
        Assert.assertEquals((Object)1L, emitter.getEvents().get(2).toMap().get("value"));
        Assert.assertEquals((Object)"task/pending/count", emitter.getEvents().get(3).toMap().get("metric"));
        Assert.assertEquals((Object)1L, emitter.getEvents().get(3).toMap().get("value"));
        Assert.assertEquals((Object)"task/waiting/count", emitter.getEvents().get(4).toMap().get("metric"));
        Assert.assertEquals((Object)1L, emitter.getEvents().get(4).toMap().get("value"));
    }
}

