/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.log;

import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.Validation;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigurator;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.LegacyDataSource;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.org.apache.druid.server.QueryStats;
import org.apache.hive.druid.org.apache.druid.server.RequestLogLine;
import org.apache.hive.druid.org.apache.druid.server.log.FilteredRequestLoggerProvider;
import org.apache.hive.druid.org.apache.druid.server.log.LoggingRequestLogger;
import org.apache.hive.druid.org.apache.druid.server.log.LoggingRequestLoggerProvider;
import org.apache.hive.druid.org.apache.druid.server.log.NoopRequestLoggerProvider;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLogger;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLoggerProvider;
import org.apache.hive.druid.org.apache.druid.server.log.TestRequestLogger;
import org.apache.hive.druid.org.apache.druid.server.log.TestRequestLoggerProvider;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FilteredRequestLoggerTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private final DefaultObjectMapper mapper = new DefaultObjectMapper();
    private final SegmentMetadataQuery testSegmentMetadataQuery = new SegmentMetadataQuery((DataSource)new LegacyDataSource("foo"), null, null, null, null, null, null, null);

    public FilteredRequestLoggerTest() {
        this.mapper.registerSubtypes(new Class[]{LoggingRequestLoggerProvider.class, FilteredRequestLoggerProvider.class, TestRequestLoggerProvider.class, NoopRequestLoggerProvider.class});
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ObjectMapper.class, (Object)this.mapper);
        this.mapper.setInjectableValues((InjectableValues)injectableValues);
    }

    @Test
    public void testFilterBelowThreshold() throws IOException {
        RequestLogger delegate = (RequestLogger)EasyMock.createStrictMock(RequestLogger.class);
        delegate.logNativeQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        delegate.logSqlQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        FilteredRequestLoggerProvider.FilteredRequestLogger logger = new FilteredRequestLoggerProvider.FilteredRequestLogger(delegate, 1000L, 2000L, (List)ImmutableList.of());
        RequestLogLine nativeRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)nativeRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)100))).once();
        RequestLogLine sqlRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)sqlRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"sqlQuery/time", (Object)1000)));
        EasyMock.replay((Object[])new Object[]{nativeRequestLogLine, sqlRequestLogLine, delegate});
        logger.logNativeQuery(nativeRequestLogLine);
        logger.logSqlQuery(sqlRequestLogLine);
    }

    @Test
    public void testNotFilterAboveThreshold() throws IOException {
        RequestLogger delegate = (RequestLogger)EasyMock.createStrictMock(RequestLogger.class);
        delegate.logNativeQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().times(2);
        delegate.logSqlQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().times(2);
        FilteredRequestLoggerProvider.FilteredRequestLogger logger = new FilteredRequestLoggerProvider.FilteredRequestLogger(delegate, 1000L, 2000L, (List)ImmutableList.of());
        RequestLogLine nativeRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)nativeRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)10000))).once();
        EasyMock.expect((Object)nativeRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)1000))).once();
        EasyMock.expect((Object)nativeRequestLogLine.getQuery()).andReturn((Object)this.testSegmentMetadataQuery).times(2);
        RequestLogLine sqlRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)sqlRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"sqlQuery/time", (Object)10000))).once();
        EasyMock.expect((Object)sqlRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"sqlQuery/time", (Object)2000))).once();
        EasyMock.expect((Object)sqlRequestLogLine.getQuery()).andReturn((Object)this.testSegmentMetadataQuery).times(2);
        EasyMock.replay((Object[])new Object[]{nativeRequestLogLine, sqlRequestLogLine, delegate});
        logger.logNativeQuery(nativeRequestLogLine);
        logger.logNativeQuery(nativeRequestLogLine);
        logger.logSqlQuery(sqlRequestLogLine);
        logger.logSqlQuery(sqlRequestLogLine);
        EasyMock.verify((Object[])new Object[]{nativeRequestLogLine, sqlRequestLogLine, delegate});
    }

    @Test
    public void testNotFilterAboveThresholdSkipSegmentMetadata() throws IOException {
        RequestLogger delegate = (RequestLogger)EasyMock.createStrictMock(RequestLogger.class);
        delegate.logNativeQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        delegate.logSqlQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        FilteredRequestLoggerProvider.FilteredRequestLogger logger = new FilteredRequestLoggerProvider.FilteredRequestLogger(delegate, 1000L, 2000L, (List)ImmutableList.of((Object)"segmentMetadata"));
        RequestLogLine nativeRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)nativeRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)10000))).once();
        EasyMock.expect((Object)nativeRequestLogLine.getQuery()).andReturn((Object)this.testSegmentMetadataQuery).once();
        RequestLogLine sqlRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)sqlRequestLogLine.getQueryStats()).andReturn((Object)new QueryStats((Map)ImmutableMap.of((Object)"sqlQuery/time", (Object)10000))).once();
        EasyMock.expect((Object)sqlRequestLogLine.getQuery()).andReturn((Object)this.testSegmentMetadataQuery).once();
        EasyMock.replay((Object[])new Object[]{nativeRequestLogLine, sqlRequestLogLine, delegate});
        logger.logNativeQuery(nativeRequestLogLine);
        logger.logSqlQuery(sqlRequestLogLine);
    }

    @Test
    public void testConfiguration() {
        Properties properties = new Properties();
        properties.setProperty("log.type", "filtered");
        properties.setProperty("log.queryTimeThresholdMs", "100");
        properties.setProperty("log.delegate.type", "slf4j");
        properties.setProperty("log.delegate.setMDC", "true");
        properties.setProperty("log.delegate.setContextMDC", "true");
        JsonConfigurator configurator = new JsonConfigurator((ObjectMapper)this.mapper, Validation.buildDefaultValidatorFactory().getValidator());
        FilteredRequestLoggerProvider provider = (FilteredRequestLoggerProvider)configurator.configurate(properties, "log", RequestLoggerProvider.class);
        FilteredRequestLoggerProvider.FilteredRequestLogger logger = (FilteredRequestLoggerProvider.FilteredRequestLogger)provider.get();
        LoggingRequestLogger delegate = (LoggingRequestLogger)logger.getDelegate();
        Assert.assertEquals((long)100L, (long)logger.getQueryTimeThresholdMs());
        Assert.assertTrue((boolean)delegate.isSetContextMDC());
        Assert.assertTrue((boolean)delegate.isSetMDC());
    }

    @Test
    public void testStartStop() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("log.type", "filtered");
        properties.setProperty("log.queryTimeThresholdMs", "100");
        properties.setProperty("log.delegate.type", "test");
        JsonConfigurator configurator = new JsonConfigurator((ObjectMapper)this.mapper, Validation.buildDefaultValidatorFactory().getValidator());
        FilteredRequestLoggerProvider provider = (FilteredRequestLoggerProvider)configurator.configurate(properties, "log", RequestLoggerProvider.class);
        FilteredRequestLoggerProvider.FilteredRequestLogger logger = (FilteredRequestLoggerProvider.FilteredRequestLogger)provider.get();
        TestRequestLogger delegate = (TestRequestLogger)logger.getDelegate();
        Assert.assertFalse((boolean)delegate.isStarted());
        logger.start();
        Assert.assertTrue((boolean)delegate.isStarted());
        logger.stop();
        Assert.assertFalse((boolean)delegate.isStarted());
    }

    @Test
    public void testInvalidDelegateType() {
        Properties properties = new Properties();
        properties.setProperty("log.type", "filtered");
        properties.setProperty("log.queryTimeThresholdMs", "100");
        properties.setProperty("log.delegate.type", "nope");
        JsonConfigurator configurator = new JsonConfigurator((ObjectMapper)this.mapper, Validation.buildDefaultValidatorFactory().getValidator());
        this.expectedException.expect(ProvisionException.class);
        this.expectedException.expectMessage("Could not resolve type id 'nope'");
        configurator.configurate(properties, "log", RequestLoggerProvider.class);
    }

    @Test
    public void testNoDelegate() {
        Properties properties = new Properties();
        properties.setProperty("log.type", "filtered");
        properties.setProperty("log.queryTimeThresholdMs", "100");
        JsonConfigurator configurator = new JsonConfigurator((ObjectMapper)this.mapper, Validation.buildDefaultValidatorFactory().getValidator());
        this.expectedException.expect(ProvisionException.class);
        this.expectedException.expectMessage("log.delegate - may not be null");
        configurator.configurate(properties, "log", RequestLoggerProvider.class);
    }
}

