/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.listener.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.server.listener.resource.AbstractListenerHandler;
import org.apache.hive.druid.org.apache.druid.server.listener.resource.SomeBeanClass;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractListenerHandlerTest {
    final ObjectMapper mapper = new DefaultObjectMapper();
    final AtomicBoolean failPost = new AtomicBoolean(false);
    final String error_msg = "err message";
    final Object good_object = new Object();
    final AtomicBoolean shouldFail = new AtomicBoolean(false);
    final AtomicBoolean returnEmpty = new AtomicBoolean(false);
    final String error_message = "some error message";
    final String good_id = "good id";
    final String error_id = "error id";
    final Map<String, SomeBeanClass> all = ImmutableMap.of();
    final Object obj = new Object();
    final String valid_id = "some_id";
    final AbstractListenerHandler<SomeBeanClass> abstractListenerHandler = new AbstractListenerHandler<SomeBeanClass>(SomeBeanClass.TYPE_REFERENCE){

        public Response handleUpdates(InputStream inputStream, ObjectMapper mapper) {
            return null;
        }

        @Nullable
        public Object post(@NotNull Map<String, SomeBeanClass> inputObject) throws Exception {
            if (AbstractListenerHandlerTest.this.failPost.get()) {
                throw new Exception("err message");
            }
            return inputObject.isEmpty() ? null : inputObject;
        }

        @Nullable
        protected Object get(@NotNull String id) {
            if ("error id".equals(id)) {
                throw new RuntimeException("some error message");
            }
            return "good id".equals(id) ? AbstractListenerHandlerTest.this.good_object : null;
        }

        @Nullable
        protected Map<String, SomeBeanClass> getAll() {
            if (AbstractListenerHandlerTest.this.shouldFail.get()) {
                throw new RuntimeException("some error message");
            }
            return AbstractListenerHandlerTest.this.returnEmpty.get() ? null : AbstractListenerHandlerTest.this.all;
        }

        @Nullable
        protected Object delete(@NotNull String id) {
            if ("error id".equals(id)) {
                throw new RuntimeException("err message");
            }
            return "some_id".equals(id) ? AbstractListenerHandlerTest.this.obj : null;
        }
    };

    @Before
    public void setUp() {
        this.mapper.registerSubtypes(new Class[]{SomeBeanClass.class});
    }

    @Test
    public void testSimple() throws Exception {
        SomeBeanClass val = new SomeBeanClass("a");
        ByteArrayInputStream bais = new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString((Object)val)));
        Response response = this.abstractListenerHandler.handlePOST((InputStream)bais, this.mapper, "good id");
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"good id", (Object)val), (Object)response.getEntity());
    }

    @Test
    public void testSimpleAll() throws Exception {
        ImmutableMap val = ImmutableMap.of((Object)"a", (Object)new SomeBeanClass("a"));
        ByteArrayInputStream bais = new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString((Object)val)));
        Response response = this.abstractListenerHandler.handlePOSTAll((InputStream)bais, this.mapper);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertEquals((Object)val, (Object)response.getEntity());
    }

    @Test
    public void testMissingAll() throws Exception {
        ImmutableMap val = ImmutableMap.of();
        ByteArrayInputStream bais = new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString((Object)val)));
        Response response = this.abstractListenerHandler.handlePOSTAll((InputStream)bais, this.mapper);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testErrorAll() throws Exception {
        ImmutableMap val = ImmutableMap.of();
        ByteArrayInputStream bais = new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString((Object)val)));
        this.failPost.set(true);
        Response response = this.abstractListenerHandler.handlePOSTAll((InputStream)bais, this.mapper);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"err message"), (Object)response.getEntity());
    }

    @Test
    public void testError() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString((Object)new SomeBeanClass("a"))));
        this.failPost.set(true);
        Response response = this.abstractListenerHandler.handlePOST((InputStream)bais, this.mapper, "good id");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"err message"), (Object)response.getEntity());
    }

    @Test
    public void testBadInput() {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[]{0, 0, 0});
        Response response = this.abstractListenerHandler.handlePOST((InputStream)bais, this.mapper, "good id");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testBadInnerInput() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        ObjectMapper mapper = (ObjectMapper)EasyMock.createStrictMock(ObjectMapper.class);
        EasyMock.expect((Object)mapper.readValue((InputStream)EasyMock.anyObject(), (TypeReference)EasyMock.anyObject())).andThrow((Throwable)new IOException());
        EasyMock.replay((Object[])new Object[]{mapper});
        Response response = this.abstractListenerHandler.handlePOSTAll((InputStream)bais, mapper);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{mapper});
    }

    @Test
    public void testHandleSimpleDELETE() {
        Response response = this.abstractListenerHandler.handleDELETE("some_id");
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertEquals((Object)this.obj, (Object)response.getEntity());
    }

    @Test
    public void testMissingDELETE() {
        Response response = this.abstractListenerHandler.handleDELETE("not going to find it");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testErrorDELETE() {
        Response response = this.abstractListenerHandler.handleDELETE("error id");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"err message"), (Object)response.getEntity());
    }

    @Test
    public void testHandle() {
        Response response = this.abstractListenerHandler.handleGET("good id");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)this.good_object, (Object)response.getEntity());
    }

    @Test
    public void testMissingHandle() {
        Response response = this.abstractListenerHandler.handleGET("neva gonna get it");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testExceptionalHandle() {
        Response response = this.abstractListenerHandler.handleGET("error id");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error message"), (Object)response.getEntity());
    }

    @Test
    public void testHandleAll() {
        Response response = this.abstractListenerHandler.handleGETAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(this.all, (Object)response.getEntity());
    }

    @Test
    public void testExceptionalHandleAll() {
        this.shouldFail.set(true);
        Response response = this.abstractListenerHandler.handleGETAll();
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error message"), (Object)response.getEntity());
    }

    @Test
    public void testMissingHandleAll() {
        this.returnEmpty.set(true);
        Response response = this.abstractListenerHandler.handleGETAll();
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }
}

