/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.initialization;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.Jerseys;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.initialization.Initialization;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.hive.druid.org.apache.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.org.apache.druid.server.initialization.jetty.JettyBindings;
import org.apache.hive.druid.org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.hive.druid.org.apache.druid.server.security.AuthTestUtils;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.Assert;
import org.junit.Test;

public class JettyQosTest
extends BaseJettyTest {
    @Override
    protected Injector setupInjector() {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", false, null, null, true, false));
                binder.bind(JettyServerInitializer.class).to(BaseJettyTest.JettyServerInit.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.SlowResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.ExceptionResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DefaultResource.class);
                binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
                JettyBindings.addQosFilter((Binder)binder, (String)"/slow/*", (int)2);
                ServerConfig serverConfig = (ServerConfig)new ObjectMapper().convertValue((Object)ImmutableMap.of((Object)"numThreads", (Object)"2"), ServerConfig.class);
                binder.bind(ServerConfig.class).toInstance((Object)serverConfig);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        }));
    }

    @Test
    public void testNumThreads() {
        Assert.assertEquals((long)10L, (long)((QueuedThreadPool)this.server.getThreadPool()).getMaxThreads());
    }

    @Test(timeout=120000L)
    public void testQoS() throws Exception {
        int i;
        int fastThreads = 20;
        int slowThreads = 15;
        int slowRequestsPerThread = 5;
        int fastRequestsPerThread = 200;
        final HttpClient fastClient = new BaseJettyTest.ClientHolder(20).getClient();
        final HttpClient slowClient = new BaseJettyTest.ClientHolder(15).getClient();
        ExecutorService fastPool = Execs.multiThreaded((int)20, (String)"fast-%d");
        ExecutorService slowPool = Execs.multiThreaded((int)15, (String)"slow-%d");
        final CountDownLatch latch = new CountDownLatch(4000);
        final AtomicLong fastCount = new AtomicLong();
        final AtomicLong slowCount = new AtomicLong();
        final AtomicLong fastElapsed = new AtomicLong();
        final AtomicLong slowElapsed = new AtomicLong();
        for (i = 0; i < 15; ++i) {
            slowPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 5; ++i) {
                        long startTime = System.currentTimeMillis();
                        try {
                            ListenableFuture go = slowClient.go(new Request(HttpMethod.GET, new URL("http://localhost:" + JettyQosTest.this.port + "/slow/hello")), (HttpResponseHandler)StatusResponseHandler.getInstance());
                            go.get();
                            slowCount.incrementAndGet();
                            slowElapsed.addAndGet(System.currentTimeMillis() - startTime);
                            continue;
                        }
                        catch (InterruptedException go) {
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        while (this.server.getThreadPool().getIdleThreads() != 0) {
            Thread.sleep(25L);
        }
        for (i = 0; i < 20; ++i) {
            fastPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 200; ++i) {
                        long startTime = System.currentTimeMillis();
                        try {
                            ListenableFuture go = fastClient.go(new Request(HttpMethod.GET, new URL("http://localhost:" + JettyQosTest.this.port + "/default")), (HttpResponseHandler)StatusResponseHandler.getInstance());
                            go.get();
                            fastCount.incrementAndGet();
                            fastElapsed.addAndGet(System.currentTimeMillis() - startTime);
                            latch.countDown();
                            continue;
                        }
                        catch (InterruptedException go) {
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        latch.await();
        slowPool.shutdownNow();
        fastPool.shutdown();
        Assert.assertTrue((fastElapsed.get() / fastCount.get() < 500L ? 1 : 0) != 0);
    }
}

