/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.initialization;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.Jerseys;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.initialization.Initialization;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.hive.druid.org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.hive.druid.org.apache.druid.server.security.AuthTestUtils;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.eclipse.jetty.server.Server;
import org.junit.Assert;
import org.junit.Test;

public class JettyBindOnHostTest
extends BaseJettyTest {
    @Override
    protected Injector setupInjector() {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", true, null, null, true, false));
                binder.bind(JettyServerInitializer.class).to(BaseJettyTest.JettyServerInit.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DefaultResource.class);
                binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        }));
    }

    @Test
    public void testBindOnHost() throws Exception {
        Assert.assertEquals((Object)"localhost", (Object)this.server.getURI().getHost());
        URL url = new URL("http://localhost:" + this.port + "/default");
        HttpURLConnection get = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)get.getInputStream(), (Charset)StandardCharsets.UTF_8));
        HttpURLConnection post = (HttpURLConnection)url.openConnection();
        post.setRequestMethod("POST");
        Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)post.getInputStream(), (Charset)StandardCharsets.UTF_8));
    }
}

