/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http.security;

import javax.servlet.FilterChain;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.org.apache.druid.server.security.SecuritySanityCheckFilter;
import org.easymock.EasyMock;
import org.junit.Test;

public class SecuritySanityCheckFilterTest {
    @Test
    public void testValidRequest() throws Exception {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)EasyMock.createStrictMock(FilterChain.class);
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn(null).once();
        filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{req, filterChain});
        SecuritySanityCheckFilter filter = new SecuritySanityCheckFilter((ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, filterChain});
    }

    @Test
    public void testInvalidRequest() throws Exception {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)EasyMock.createStrictMock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)EasyMock.createStrictMock(FilterChain.class);
        ServletOutputStream outputStream = (ServletOutputStream)EasyMock.createNiceMock(ServletOutputStream.class);
        AuthenticationResult authenticationResult = new AuthenticationResult("does-not-belong", "does-not-belong", null, null);
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn((Object)true).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        EasyMock.expect((Object)resp.getOutputStream()).andReturn((Object)outputStream).once();
        resp.setStatus(403);
        EasyMock.expectLastCall().once();
        resp.setContentType("application/json");
        EasyMock.expectLastCall().once();
        resp.setCharacterEncoding("UTF-8");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{req, resp, filterChain, outputStream});
        SecuritySanityCheckFilter filter = new SecuritySanityCheckFilter((ObjectMapper)new DefaultObjectMapper());
        filter.doFilter((ServletRequest)req, (ServletResponse)resp, filterChain);
        EasyMock.verify((Object[])new Object[]{req, resp, filterChain, outputStream});
    }
}

