/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.client.CoordinatorServerView;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.InventoryView;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;
import org.apache.hive.druid.org.apache.druid.server.http.ServersResource;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServersResourceTest {
    private DruidServer server;
    private ServersResource serversResource;
    private ObjectMapper objectMapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        DruidServer dummyServer = new DruidServer("dummy", "host", null, 1234L, ServerType.HISTORICAL, "tier", 0);
        DataSegment segment = DataSegment.builder().dataSource("dataSource").interval(Intervals.of((String)"2016-03-22T14Z/2016-03-22T15Z")).version("v0").size(1L).build();
        dummyServer.addDataSegment(segment);
        CoordinatorServerView inventoryView = (CoordinatorServerView)EasyMock.createMock(CoordinatorServerView.class);
        EasyMock.expect((Object)inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)dummyServer)).anyTimes();
        EasyMock.expect((Object)inventoryView.getInventoryValue(dummyServer.getName())).andReturn((Object)dummyServer).anyTimes();
        EasyMock.replay((Object[])new Object[]{inventoryView});
        this.server = dummyServer;
        this.serversResource = new ServersResource((InventoryView)inventoryView);
    }

    @Test
    public void testGetClusterServersFull() throws Exception {
        Response res = this.serversResource.getClusterServers("full", null);
        String result = this.objectMapper.writeValueAsString(res.getEntity());
        String expected = "[{\"host\":\"host\",\"maxSize\":1234,\"type\":\"historical\",\"tier\":\"tier\",\"priority\":0,\"segments\":{\"dataSource_2016-03-22T14:00:00.000Z_2016-03-22T15:00:00.000Z_v0\":{\"dataSource\":\"dataSource\",\"interval\":\"2016-03-22T14:00:00.000Z/2016-03-22T15:00:00.000Z\",\"version\":\"v0\",\"loadSpec\":{},\"dimensions\":\"\",\"metrics\":\"\",\"shardSpec\":{\"type\":\"numbered\",\"partitionNum\":0,\"partitions\":1},\"binaryVersion\":null,\"size\":1,\"identifier\":\"dataSource_2016-03-22T14:00:00.000Z_2016-03-22T15:00:00.000Z_v0\"}},\"currSize\":1}]";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testGetClusterServersSimple() throws Exception {
        Response res = this.serversResource.getClusterServers(null, "simple");
        String result = this.objectMapper.writeValueAsString(res.getEntity());
        String expected = "[{\"host\":\"host\",\"tier\":\"tier\",\"type\":\"historical\",\"priority\":0,\"currSize\":1,\"maxSize\":1234}]";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testGetServerFull() throws Exception {
        Response res = this.serversResource.getServer(this.server.getName(), null);
        String result = this.objectMapper.writeValueAsString(res.getEntity());
        String expected = "{\"host\":\"host\",\"maxSize\":1234,\"type\":\"historical\",\"tier\":\"tier\",\"priority\":0,\"segments\":{\"dataSource_2016-03-22T14:00:00.000Z_2016-03-22T15:00:00.000Z_v0\":{\"dataSource\":\"dataSource\",\"interval\":\"2016-03-22T14:00:00.000Z/2016-03-22T15:00:00.000Z\",\"version\":\"v0\",\"loadSpec\":{},\"dimensions\":\"\",\"metrics\":\"\",\"shardSpec\":{\"type\":\"numbered\",\"partitionNum\":0,\"partitions\":1},\"binaryVersion\":null,\"size\":1,\"identifier\":\"dataSource_2016-03-22T14:00:00.000Z_2016-03-22T15:00:00.000Z_v0\"}},\"currSize\":1}";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testGetServerSimple() throws Exception {
        Response res = this.serversResource.getServer(this.server.getName(), "simple");
        String result = this.objectMapper.writeValueAsString(res.getEntity());
        String expected = "{\"host\":\"host\",\"tier\":\"tier\",\"type\":\"historical\",\"priority\":0,\"currSize\":1,\"maxSize\":1234}";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDruidServerSerde() throws Exception {
        DruidServer server = new DruidServer("dummy", "dummyHost", null, 1234L, ServerType.HISTORICAL, "dummyTier", 1);
        String serverJson = this.objectMapper.writeValueAsString((Object)server);
        String expected = "{\"name\":\"dummy\",\"host\":\"dummyHost\",\"hostAndTlsPort\":null,\"maxSize\":1234,\"type\":\"historical\",\"tier\":\"dummyTier\",\"priority\":1}";
        Assert.assertEquals((Object)expected, (Object)serverJson);
        DruidServer deserializedServer = (DruidServer)this.objectMapper.readValue(serverJson, DruidServer.class);
        Assert.assertEquals((Object)server, (Object)deserializedServer);
    }

    @Test
    public void testDruidServerMetadataSerde() throws Exception {
        DruidServerMetadata metadata = new DruidServerMetadata("dummy", "host", null, 1234L, ServerType.HISTORICAL, "tier", 1);
        String metadataJson = this.objectMapper.writeValueAsString((Object)metadata);
        String expected = "{\"name\":\"dummy\",\"host\":\"host\",\"hostAndTlsPort\":null,\"maxSize\":1234,\"type\":\"historical\",\"tier\":\"tier\",\"priority\":1}";
        Assert.assertEquals((Object)expected, (Object)metadataJson);
        DruidServerMetadata deserializedMetadata = (DruidServerMetadata)this.objectMapper.readValue(metadataJson, DruidServerMetadata.class);
        Assert.assertEquals((Object)metadata, (Object)deserializedMetadata);
        metadata = new DruidServerMetadata("host:123", "host:123", null, 0L, ServerType.HISTORICAL, "t1", 0);
        Assert.assertEquals((Object)metadata, (Object)this.objectMapper.readValue("{\"name\":\"host:123\",\"maxSize\":0,\"type\":\"HISTORICAL\",\"tier\":\"t1\",\"priority\":0,\"host\":\"host:123\"}", DruidServerMetadata.class));
        metadata = new DruidServerMetadata("host:123", "host:123", "host:214", 0L, ServerType.HISTORICAL, "t1", 0);
        Assert.assertEquals((Object)metadata, (Object)this.objectMapper.readValue("{\"name\":\"host:123\",\"maxSize\":0,\"type\":\"HISTORICAL\",\"tier\":\"t1\",\"priority\":0,\"host\":\"host:123\",\"hostAndTlsPort\":\"host:214\"}", DruidServerMetadata.class));
        Assert.assertEquals((Object)metadata, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)metadata), DruidServerMetadata.class));
    }
}

