/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.org.apache.druid.server.http.CoordinatorResource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorResourceTest {
    private DruidCoordinator mock;

    @Before
    public void setUp() {
        this.mock = (DruidCoordinator)EasyMock.createStrictMock(DruidCoordinator.class);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    @Test
    public void testLeader() {
        EasyMock.expect((Object)this.mock.getCurrentLeader()).andReturn((Object)"boz").once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorResource(this.mock).getLeader();
        Assert.assertEquals((Object)"boz", (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testIsLeader() {
        EasyMock.expect((Object)this.mock.isLeader()).andReturn((Object)true).once();
        EasyMock.expect((Object)this.mock.isLeader()).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response1 = new CoordinatorResource(this.mock).isLeader();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"leader", (Object)true), (Object)response1.getEntity());
        Assert.assertEquals((long)200L, (long)response1.getStatus());
        Response response2 = new CoordinatorResource(this.mock).isLeader();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"leader", (Object)false), (Object)response2.getEntity());
        Assert.assertEquals((long)404L, (long)response2.getStatus());
    }
}

