/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.junit.Assert;
import org.junit.Test;

public class CoordinatorDynamicConfigTest {
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"decommissioningNodes\": [\"host1\", \"host2\"],\n  \"decommissioningMaxPercentOfMaxSegmentsToMove\": 9\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of((Object)"host1", (Object)"host2");
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)decommissioning, 9);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 9);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer.valueOf(5)).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5);
    }

    @Test
    public void testDecommissioningParametersBackwardCompatibility() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of();
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)decommissioning, 0);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 0);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer.valueOf(5)).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5);
    }

    @Test
    public void testSerdeWithStringinKillDataSourceWhitelist() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killDataSourceWhitelist\": \"test1, test2\", \n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)ImmutableSet.of((Object)"test1", (Object)"test2"), false, 1, (Set<String>)ImmutableSet.of(), 0);
    }

    @Test
    public void testSerdeWithKillAllDataSources() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killAllDataSources\": true,\n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)ImmutableSet.of(), true, 1, (Set<String>)ImmutableSet.of(), 0);
        try {
            jsonStr = "{\n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"killAllDataSources\": true\n}\n";
            this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class);
            Assert.fail((String)"deserialization should fail.");
        }
        catch (JsonMappingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IAE));
        }
    }

    @Test
    public void testDeserializeWithoutMaxSegmentsInNodeLoadingQueue() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killAllDataSources\": true\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 2, true, (Set<String>)ImmutableSet.of(), true, 0, (Set<String>)ImmutableSet.of(), 0);
    }

    @Test
    public void testBuilderDefaults() {
        CoordinatorDynamicConfig defaultConfig = CoordinatorDynamicConfig.builder().build();
        ImmutableSet emptyList = ImmutableSet.of();
        this.assertConfig(defaultConfig, 900000L, 524288000L, 100, 5, 15, 10, 1, false, (Set<String>)emptyList, false, 0, (Set<String>)emptyList, 70);
    }

    @Test
    public void testUpdate() {
        CoordinatorDynamicConfig current = CoordinatorDynamicConfig.builder().withSpecificDataSourcesToKillUnusedSegmentsIn((Set)ImmutableSet.of((Object)"x")).build();
        Assert.assertEquals((Object)current, (Object)new CoordinatorDynamicConfig.Builder(null, null, null, null, null, null, null, null, null, null, null, null, null, null).build(current));
    }

    @Test
    public void testEqualsAndHashCodeSanity() {
        CoordinatorDynamicConfig config1 = CoordinatorDynamicConfig.builder().build();
        CoordinatorDynamicConfig config2 = CoordinatorDynamicConfig.builder().build();
        Assert.assertEquals((Object)config1, (Object)config2);
        Assert.assertEquals((long)config1.hashCode(), (long)config2.hashCode());
    }

    private void assertConfig(CoordinatorDynamicConfig config, long expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, long expectedMergeBytesLimit, int expectedMergeSegmentsLimit, int expectedMaxSegmentsToMove, int expectedReplicantLifetime, int expectedReplicationThrottleLimit, int expectedBalancerComputeThreads, boolean expectedEmitingBalancingStats, Set<String> expectedSpecificDataSourcesToKillUnusedSegmentsIn, boolean expectedKillUnusedSegmentsInAllDataSources, int expectedMaxSegmentsInNodeLoadingQueue, Set<String> decommissioningNodes, int decommissioningMaxPercentOfMaxSegmentsToMove) {
        Assert.assertEquals((long)expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, (long)config.getLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments());
        Assert.assertEquals((long)expectedMergeBytesLimit, (long)config.getMergeBytesLimit());
        Assert.assertEquals((long)expectedMergeSegmentsLimit, (long)config.getMergeSegmentsLimit());
        Assert.assertEquals((long)expectedMaxSegmentsToMove, (long)config.getMaxSegmentsToMove());
        Assert.assertEquals((long)expectedReplicantLifetime, (long)config.getReplicantLifetime());
        Assert.assertEquals((long)expectedReplicationThrottleLimit, (long)config.getReplicationThrottleLimit());
        Assert.assertEquals((long)expectedBalancerComputeThreads, (long)config.getBalancerComputeThreads());
        Assert.assertEquals((Object)expectedEmitingBalancingStats, (Object)config.emitBalancingStats());
        Assert.assertEquals(expectedSpecificDataSourcesToKillUnusedSegmentsIn, (Object)config.getSpecificDataSourcesToKillUnusedSegmentsIn());
        Assert.assertEquals((Object)expectedKillUnusedSegmentsInAllDataSources, (Object)config.isKillUnusedSegmentsInAllDataSources());
        Assert.assertEquals((long)expectedMaxSegmentsInNodeLoadingQueue, (long)config.getMaxSegmentsInNodeLoadingQueue());
        Assert.assertEquals(decommissioningNodes, (Object)config.getDecommissioningNodes());
        Assert.assertEquals((long)decommissioningMaxPercentOfMaxSegmentsToMove, (long)config.getDecommissioningMaxPercentOfMaxSegmentsToMove());
    }
}

