/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.PeriodLoadRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class PeriodLoadRuleTest {
    private static final DataSegment.Builder BUILDER = DataSegment.builder().dataSource("test").version(DateTimes.nowUtc().toString()).shardSpec((ShardSpec)NoneShardSpec.instance()).size(0L);

    @Test
    public void testAppliesToAll() {
        DateTime now = DateTimes.of((String)"2013-01-01");
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P5000Y"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(Intervals.of((String)"2012-01-01/2012-12-31")).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(Intervals.of((String)"1000-01-01/2012-12-31")).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(Intervals.of((String)"0500-01-01/2100-12-31")).build(), now));
    }

    @Test
    public void testAppliesToPeriod() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P1M"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusWeeks(1), (ReadableInstant)now)).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusDays(1), (ReadableInstant)now.plusDays(1))).build(), now));
        Assert.assertFalse((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
    }

    @Test
    public void testAppliesToPartialOverlap() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P1M"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusWeeks(1), (ReadableInstant)now.plusWeeks(1))).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusMonths(1).minusWeeks(1), (ReadableInstant)now.minusMonths(1).plusWeeks(1))).build(), now));
    }

    @Test
    public void testIncludeFuture() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodLoadRule includeFutureRule = new PeriodLoadRule(new Period((Object)"P2D"), Boolean.valueOf(true), (Map)ImmutableMap.of((Object)"", (Object)0));
        PeriodLoadRule notIncludeFutureRule = new PeriodLoadRule(new Period((Object)"P2D"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0));
        Assert.assertTrue((boolean)includeFutureRule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
        Assert.assertFalse((boolean)notIncludeFutureRule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
    }

    @Test
    public void testSerdeNull() throws Exception {
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P1D"), null, null);
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule.getPeriod(), (Object)((PeriodLoadRule)reread).getPeriod());
        Assert.assertEquals((Object)rule.isIncludeFuture(), (Object)((PeriodLoadRule)reread).isIncludeFuture());
        Assert.assertEquals((Object)true, (Object)rule.isIncludeFuture());
        Assert.assertEquals((Object)rule.getTieredReplicants(), (Object)((PeriodLoadRule)reread).getTieredReplicants());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)rule.getTieredReplicants());
    }

    @Test
    public void testMappingNull() throws Exception {
        String inputJson = "{\n      \"period\": \"P1D\",\n      \"type\": \"loadByPeriod\"\n    }";
        String expectedJson = "{\n      \"period\": \"P1D\",\n      \"includeFuture\": true,\n      \"tieredReplicants\": {\n        \"_default_tier\": 2\n      },\n      \"type\": \"loadByPeriod\"\n    }";
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        PeriodLoadRule inputPeriodLoadRule = (PeriodLoadRule)jsonMapper.readValue(inputJson, PeriodLoadRule.class);
        PeriodLoadRule expectedPeriodLoadRule = (PeriodLoadRule)jsonMapper.readValue(expectedJson, PeriodLoadRule.class);
        Assert.assertEquals((Object)expectedPeriodLoadRule.getTieredReplicants(), (Object)inputPeriodLoadRule.getTieredReplicants());
        Assert.assertEquals((Object)expectedPeriodLoadRule.getPeriod(), (Object)inputPeriodLoadRule.getPeriod());
        Assert.assertEquals((Object)expectedPeriodLoadRule.isIncludeFuture(), (Object)inputPeriodLoadRule.isIncludeFuture());
    }
}

