/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.PeriodDropBeforeRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class PeriodDropBeforeRuleTest {
    private static final DataSegment.Builder BUILDER = DataSegment.builder().dataSource("test").version(DateTimes.of((String)"2012-12-31T01:00:00").toString()).shardSpec((ShardSpec)NoneShardSpec.instance()).size(0L);

    @Test
    public void testSerde() throws Exception {
        PeriodDropBeforeRule rule = new PeriodDropBeforeRule(new Period((Object)"P1D"));
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule.getPeriod(), (Object)((PeriodDropBeforeRule)reread).getPeriod());
    }

    @Test
    public void testDropBefore() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodDropBeforeRule rule = new PeriodDropBeforeRule(new Period((Object)"P1D"));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusDays(3), (ReadableInstant)now.minusDays(2))).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusDays(2), (ReadableInstant)now.minusDays(1))).build(), now));
        Assert.assertFalse((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusDays(1), (ReadableInstant)now)).build(), now));
        Assert.assertFalse((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now, (ReadableInstant)now.plusDays(1))).build(), now));
    }
}

