/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule;
import org.junit.Assert;
import org.junit.Test;

public class IntervalLoadRuleTest {
    @Test
    public void testSerde() throws Exception {
        IntervalLoadRule rule = new IntervalLoadRule(Intervals.of((String)"0/3000"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2));
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule, (Object)reread);
    }

    @Test
    public void testSerdeNullTieredReplicants() throws Exception {
        IntervalLoadRule rule = new IntervalLoadRule(Intervals.of((String)"0/3000"), null);
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule, (Object)reread);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)rule.getTieredReplicants());
    }

    @Test
    public void testMappingNullTieredReplicants() throws Exception {
        String inputJson = "    {\n      \"interval\": \"0000-01-01T00:00:00.000-05:50:36/3000-01-01T00:00:00.000-06:00\",\n      \"type\": \"loadByInterval\"\n    }";
        String expectedJson = "{\n      \"interval\": \"0000-01-01T00:00:00.000-05:50:36/3000-01-01T00:00:00.000-06:00\",\n      \"tieredReplicants\": {\n        \"_default_tier\": 2\n      },\n      \"type\": \"loadByInterval\"\n    }";
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        IntervalLoadRule inputIntervalLoadRule = (IntervalLoadRule)jsonMapper.readValue(inputJson, IntervalLoadRule.class);
        IntervalLoadRule expectedIntervalLoadRule = (IntervalLoadRule)jsonMapper.readValue(expectedJson, IntervalLoadRule.class);
        Assert.assertEquals((Object)expectedIntervalLoadRule, (Object)inputIntervalLoadRule);
    }
}

