/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.CompactionSegmentIterator;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.NewestSegmentFirstPolicy;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.SegmentCompactorUtil;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.Partitions;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.assertj.core.api.Assertions;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Test;

public class NewestSegmentFirstPolicyTest {
    private static final String DATA_SOURCE = "dataSource";
    private static final long DEFAULT_SEGMENT_SIZE = 1000L;
    private static final int DEFAULT_NUM_SEGMENTS_PER_SHARD = 4;
    private final NewestSegmentFirstPolicy policy = new NewestSegmentFirstPolicy((ObjectMapper)new DefaultObjectMapper());

    @Test
    public void testLargeOffsetAndSmallSegmentInterval() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P2D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T03:00:00/2017-11-15T04:00:00"), true);
    }

    @Test
    public void testSmallOffsetAndLargeSegmentInterval() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"PT1M"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-17T02:00:00/2017-11-17T03:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-16T06:00:00/2017-11-16T07:00:00"), true);
    }

    @Test
    public void testLargeGapInData() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"PT1H1M"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-15T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-17T01:00:00/2017-11-17T02:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T06:00:00/2017-11-15T07:00:00"), true);
    }

    @Test
    public void testHugeShard() {
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P1D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-17T00:00:00/2017-11-18T03:00:00"), new Period((Object)"PT1H"), 200L, 4), new SegmentGenerateSpec(Intervals.of((String)"2017-11-09T00:00:00/2017-11-17T00:00:00"), new Period((Object)"P2D"), 13000L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-11-05T00:00:00/2017-11-09T00:00:00"), new Period((Object)"PT1H"), 200L, 4))), Collections.emptyMap());
        Interval lastInterval = null;
        while (iterator.hasNext()) {
            List segments = (List)iterator.next();
            lastInterval = ((DataSegment)segments.get(0)).getInterval();
            Interval prevInterval = null;
            for (DataSegment segment : segments) {
                if (prevInterval != null && !prevInterval.getStart().equals((Object)segment.getInterval().getStart())) {
                    Assert.assertEquals((Object)prevInterval.getEnd(), (Object)segment.getInterval().getStart());
                }
                prevInterval = segment.getInterval();
            }
        }
        Assert.assertNotNull(lastInterval);
        Assert.assertEquals((Object)Intervals.of((String)"2017-11-05T00:00:00/2017-11-05T01:00:00"), lastInterval);
    }

    @Test
    public void testManySegmentsPerShard() {
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(800000L, new Period((Object)"P1D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-04T01:00:00/2017-12-05T03:00:00"), new Period((Object)"PT1H"), 375L, 80), new SegmentGenerateSpec(Intervals.of((String)"2017-12-04T00:00:00/2017-12-04T01:00:00"), new Period((Object)"PT1H"), 200L, 150), new SegmentGenerateSpec(Intervals.of((String)"2017-12-03T18:00:00/2017-12-04T00:00:00"), new Period((Object)"PT6H"), 200000L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-12-03T11:00:00/2017-12-03T18:00:00"), new Period((Object)"PT1H"), 375L, 80))), Collections.emptyMap());
        Interval lastInterval = null;
        while (iterator.hasNext()) {
            List segments = (List)iterator.next();
            lastInterval = ((DataSegment)segments.get(0)).getInterval();
            Interval prevInterval = null;
            for (DataSegment segment : segments) {
                if (prevInterval != null && !prevInterval.getStart().equals((Object)segment.getInterval().getStart())) {
                    Assert.assertEquals((Object)prevInterval.getEnd(), (Object)segment.getInterval().getStart());
                }
                prevInterval = segment.getInterval();
            }
        }
        Assert.assertNotNull(lastInterval);
        Assert.assertEquals((Object)Intervals.of((String)"2017-12-03T11:00:00/2017-12-03T12:00:00"), lastInterval);
    }

    @Test
    public void testSkipUnknownDataSource() {
        String unknownDataSource = "unknown";
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)"unknown", (Object)this.createCompactionConfig(10000L, new Period((Object)"P2D")), (Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P2D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T03:00:00/2017-11-15T04:00:00"), true);
    }

    @Test
    public void testClearSegmentsToCompactWhenSkippingSegments() {
        long inputSegmentSizeBytes = 800000L;
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-03T00:00:00/2017-12-04T00:00:00"), new Period((Object)"P1D"), 400010L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-12-02T00:00:00/2017-12-03T00:00:00"), new Period((Object)"P1D"), 800010L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-12-01T00:00:00/2017-12-02T00:00:00"), new Period((Object)"P1D"), 266676L, 2));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(800000L, new Period((Object)"P0D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-03/2017-12-04"), Partitions.ONLY_COMPLETE));
        expectedSegmentsToCompact.sort(Comparator.naturalOrder());
        ArrayList expectedSegmentsToCompact2 = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-01/2017-12-02"), Partitions.ONLY_COMPLETE));
        expectedSegmentsToCompact2.sort(Comparator.naturalOrder());
        Assertions.assertThat((Iterator)iterator).toIterable().containsExactly((Object[])new List[]{expectedSegmentsToCompact, expectedSegmentsToCompact2});
    }

    @Test
    public void testIfFirstSegmentIsInSkipOffset() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-02T14:00:00/2017-12-03T00:00:00"), new Period((Object)"PT5H"), 40000L, 1));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P1D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIfFirstSegmentOverlapsSkipOffset() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-01T23:00:00/2017-12-03T00:00:00"), new Period((Object)"PT5H"), 40000L, 1));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P1D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testWithSkipIntervals() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P1D"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), (Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)ImmutableList.of((Object)Intervals.of((String)"2017-11-16T00:00:00/2017-11-17T00:00:00"), (Object)Intervals.of((String)"2017-11-15T00:00:00/2017-11-15T20:00:00"), (Object)Intervals.of((String)"2017-11-13T00:00:00/2017-11-14T01:00:00"))));
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-15T20:00:00/2017-11-15T21:00:00"), Intervals.of((String)"2017-11-15T23:00:00/2017-11-16T00:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T01:00:00/2017-11-14T02:00:00"), Intervals.of((String)"2017-11-14T23:00:00/2017-11-15T00:00:00"), true);
    }

    @Test
    public void testHoleInSearchInterval() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"PT1H"))), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T00:00:00/2017-11-17T00:00:00"), segmentPeriod))), (Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)ImmutableList.of((Object)Intervals.of((String)"2017-11-16T04:00:00/2017-11-16T10:00:00"), (Object)Intervals.of((String)"2017-11-16T14:00:00/2017-11-16T20:00:00"))));
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-16T22:00:00/2017-11-16T23:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T10:00:00/2017-11-16T11:00:00"), Intervals.of((String)"2017-11-16T13:00:00/2017-11-16T14:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T00:00:00/2017-11-16T01:00:00"), Intervals.of((String)"2017-11-16T03:00:00/2017-11-16T04:00:00"), true);
    }

    private static void assertCompactSegmentIntervals(CompactionSegmentIterator iterator, Period segmentPeriod, Interval from, Interval to, boolean assertLast) {
        Interval expectedSegmentIntervalStart = to;
        while (iterator.hasNext()) {
            List segments = (List)iterator.next();
            Interval firstInterval = ((DataSegment)segments.get(0)).getInterval();
            Assert.assertTrue((String)"Intervals should be same or abutting", (boolean)segments.stream().allMatch(segment -> segment.getInterval().isEqual((ReadableInterval)firstInterval) || segment.getInterval().abuts((ReadableInterval)firstInterval)));
            ArrayList<Interval> expectedIntervals = new ArrayList<Interval>(segments.size());
            for (int i = 0; i < segments.size(); ++i) {
                if (i > 0 && i % 4 == 0) {
                    expectedSegmentIntervalStart = new Interval((ReadablePeriod)segmentPeriod, (ReadableInstant)expectedSegmentIntervalStart.getStart());
                }
                expectedIntervals.add(expectedSegmentIntervalStart);
            }
            expectedIntervals.sort(Comparators.intervalsByStartThenEnd());
            Assert.assertEquals(expectedIntervals, segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
            if (expectedSegmentIntervalStart.equals((Object)from)) break;
            expectedSegmentIntervalStart = new Interval((ReadablePeriod)segmentPeriod, (ReadableInstant)expectedSegmentIntervalStart.getStart());
        }
        if (assertLast) {
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    private static VersionedIntervalTimeline<String, DataSegment> createTimeline(SegmentGenerateSpec ... specs) {
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        String version = DateTimes.nowUtc().toString();
        List<SegmentGenerateSpec> orderedSpecs = Arrays.asList(specs);
        orderedSpecs.sort(Comparator.comparing(s -> ((SegmentGenerateSpec)s).totalInterval, Comparators.intervalsByStartThenEnd().reversed()));
        for (SegmentGenerateSpec spec : orderedSpecs) {
            Interval remainingInterval = spec.totalInterval;
            while (!Intervals.isEmpty((Interval)remainingInterval)) {
                Interval segmentInterval = remainingInterval.toDuration().isLongerThan((ReadableDuration)spec.segmentPeriod.toStandardDuration()) ? new Interval((ReadablePeriod)spec.segmentPeriod, (ReadableInstant)remainingInterval.getEnd()) : remainingInterval;
                for (int i = 0; i < spec.numSegmentsPerShard; ++i) {
                    NumberedShardSpec shardSpec = new NumberedShardSpec(i, spec.numSegmentsPerShard);
                    DataSegment segment = new DataSegment(DATA_SOURCE, segmentInterval, version, null, (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)shardSpec, Integer.valueOf(0), spec.segmentSize);
                    segments.add(segment);
                }
                remainingInterval = SegmentCompactorUtil.removeIntervalFromEnd((Interval)remainingInterval, (Interval)segmentInterval);
            }
        }
        return VersionedIntervalTimeline.forSegments(segments);
    }

    private DataSourceCompactionConfig createCompactionConfig(long inputSegmentSizeBytes, Period skipOffsetFromLatest) {
        return new DataSourceCompactionConfig(DATA_SOURCE, Integer.valueOf(0), Long.valueOf(inputSegmentSizeBytes), null, skipOffsetFromLatest, null, null);
    }

    private static class SegmentGenerateSpec {
        private final Interval totalInterval;
        private final Period segmentPeriod;
        private final long segmentSize;
        private final int numSegmentsPerShard;

        SegmentGenerateSpec(Interval totalInterval, Period segmentPeriod) {
            this(totalInterval, segmentPeriod, 1000L, 4);
        }

        SegmentGenerateSpec(Interval totalInterval, Period segmentPeriod, long segmentSize, int numSegmentsPerShard) {
            Preconditions.checkArgument((numSegmentsPerShard >= 1 ? 1 : 0) != 0);
            this.totalInterval = totalInterval;
            this.segmentPeriod = segmentPeriod;
            this.segmentSize = segmentSize;
            this.numSegmentsPerShard = numSegmentsPerShard;
        }
    }
}

