/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.helper;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.NewestSegmentFirstIterator;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class NewestSegmentFirstIteratorTest {
    @Test
    public void testFilterSkipIntervals() {
        Interval totalInterval = Intervals.of((String)"2018-01-01/2019-01-01");
        ImmutableList expectedSkipIntervals = ImmutableList.of((Object)Intervals.of((String)"2018-01-15/2018-03-02"), (Object)Intervals.of((String)"2018-07-23/2018-10-01"), (Object)Intervals.of((String)"2018-10-02/2018-12-25"), (Object)Intervals.of((String)"2018-12-31/2019-01-01"));
        List skipIntervals = NewestSegmentFirstIterator.filterSkipIntervals((Interval)totalInterval, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2017-12-01/2018-01-15"), Intervals.of((String)"2018-03-02/2018-07-23"), Intervals.of((String)"2018-10-01/2018-10-02"), Intervals.of((String)"2018-12-25/2018-12-31")}));
        Assert.assertEquals((Object)expectedSkipIntervals, (Object)skipIntervals);
    }

    @Test
    public void testAddSkipIntervalFromLatestAndSort() {
        ImmutableList expectedIntervals = ImmutableList.of((Object)Intervals.of((String)"2018-12-24/2018-12-25"), (Object)Intervals.of((String)"2018-12-29/2019-01-01"));
        List fullSkipIntervals = NewestSegmentFirstIterator.sortAndAddSkipIntervalFromLatest((DateTime)DateTimes.of((String)"2019-01-01"), (Period)new Period(72, 0, 0, 0), (List)ImmutableList.of((Object)Intervals.of((String)"2018-12-30/2018-12-31"), (Object)Intervals.of((String)"2018-12-24/2018-12-25")));
        Assert.assertEquals((Object)expectedIntervals, (Object)fullSkipIntervals);
    }
}

