/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.client.DataSourcesSnapshot;
import org.apache.hive.druid.org.apache.druid.client.indexing.ClientCompactQueryTuningConfig;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.org.apache.druid.client.indexing.NoopIndexingServiceClient;
import org.apache.hive.druid.org.apache.druid.indexer.TaskStatusPlus;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.hive.druid.org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.org.apache.druid.server.coordinator.helper.DruidCoordinatorSegmentCompactor;
import org.apache.hive.druid.org.apache.druid.timeline.CompactionState;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorSegmentCompactorTest {
    private static final String DATA_SOURCE_PREFIX = "dataSource_";
    private final IndexingServiceClient indexingServiceClient = new NoopIndexingServiceClient(){
        private int compactVersionSuffix = 0;
        private int idSuffix = 0;

        @Override
        public String compactSegments(List<DataSegment> segments, int compactionTaskPriority, ClientCompactQueryTuningConfig tuningConfig, Map<String, Object> context) {
            Preconditions.checkArgument((segments.size() > 1 ? 1 : 0) != 0);
            Collections.sort(segments);
            Interval compactInterval = new Interval((ReadableInstant)segments.get(0).getInterval().getStart(), (ReadableInstant)segments.get(segments.size() - 1).getInterval().getEnd());
            VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)DruidCoordinatorSegmentCompactorTest.this.dataSources.get(segments.get(0).getDataSource());
            segments.forEach(segment -> timeline.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk(segment)));
            String version = "newVersion_" + this.compactVersionSuffix++;
            long segmentSize = segments.stream().mapToLong(DataSegment::getSize).sum() / 2L;
            for (int i = 0; i < 2; ++i) {
                DataSegment compactSegment = new DataSegment(segments.get(0).getDataSource(), compactInterval, version, null, segments.get(0).getDimensions(), segments.get(0).getMetrics(), (ShardSpec)new NumberedShardSpec(i, 0), new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(tuningConfig.getMaxRowsPerSegment(), Long.valueOf(tuningConfig.getMaxTotalRowsOr(Long.MAX_VALUE))), (Map)ImmutableMap.of((Object)"bitmap", (Object)ImmutableMap.of((Object)"type", (Object)"concise"), (Object)"dimensionCompression", (Object)"lz4", (Object)"metricCompression", (Object)"lz4", (Object)"longEncoding", (Object)"longs")), Integer.valueOf(1), segmentSize);
                timeline.add(compactInterval, (Object)compactSegment.getVersion(), compactSegment.getShardSpec().createChunk((Object)compactSegment));
            }
            return "task_" + this.idSuffix++;
        }

        @Override
        public List<TaskStatusPlus> getActiveTasks() {
            return Collections.emptyList();
        }

        @Override
        public int getTotalWorkerCapacity() {
            return 10;
        }
    };
    private Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources;

    @Before
    public void setup() {
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            for (int j : new int[]{0, 1, 2, 3, 7, 8}) {
                for (int k = 0; k < 4; ++k) {
                    segments.add(DruidCoordinatorSegmentCompactorTest.createSegment(dataSource, j, true, k));
                    segments.add(DruidCoordinatorSegmentCompactorTest.createSegment(dataSource, j, false, k));
                }
            }
        }
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of()).getUsedSegmentsTimelinesPerDataSource();
    }

    private static DataSegment createSegment(String dataSource, int startDay, boolean beforeNoon, int partition) {
        NumberedShardSpec shardSpec = new NumberedShardSpec(partition, 2);
        Interval interval = beforeNoon ? Intervals.of((String)StringUtils.format((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{startDay + 1, startDay + 1})) : Intervals.of((String)StringUtils.format((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{startDay + 1, startDay + 2}));
        return new DataSegment(dataSource, interval, "version", null, (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)shardSpec, Integer.valueOf(0), 10L);
    }

    @Test
    public void testRun() {
        DruidCoordinatorSegmentCompactor compactor = new DruidCoordinatorSegmentCompactor((ObjectMapper)new DefaultObjectMapper(), this.indexingServiceClient);
        Supplier<String> expectedVersionSupplier = new Supplier<String>(){
            private int i = 0;

            @Override
            public String get() {
                return "newVersion_" + this.i++;
            }
        };
        int expectedCompactTaskCount = 1;
        int expectedRemainingSegments = 400;
        this.assertCompactSegments(compactor, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{9, 9}), expectedRemainingSegments, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactor, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{8, 9}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactor, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{8, 8}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactor, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{4, 5}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        for (int endDay = 4; endDay > 1; --endDay) {
            this.assertCompactSegments(compactor, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{endDay, endDay}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
            this.assertCompactSegments(compactor, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{endDay - 1, endDay}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        }
        this.assertLastSegmentNotCompacted(compactor);
    }

    private CoordinatorStats runCompactor(DruidCoordinatorSegmentCompactor compactor) {
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withUsedSegmentsTimelinesPerDataSourceInTest(this.dataSources).withCompactionConfig(CoordinatorCompactionConfig.from(DruidCoordinatorSegmentCompactorTest.createCompactionConfigs())).build();
        return compactor.run(params).getCoordinatorStats();
    }

    private void assertCompactSegments(DruidCoordinatorSegmentCompactor compactor, Interval expectedInterval, int expectedRemainingSegments, int expectedCompactTaskCount, Supplier<String> expectedVersionSupplier) {
        int i;
        for (i = 0; i < 3; ++i) {
            CoordinatorStats stats = this.runCompactor(compactor);
            Assert.assertEquals((long)expectedCompactTaskCount, (long)stats.getGlobalStat("compactTaskCount"));
            if (expectedRemainingSegments > 0) {
                long numDataSourceOfExpectedRemainingSegments = stats.getDataSources("segmentSizeWaitCompact").stream().mapToLong(ds -> stats.getDataSourceStat("segmentSizeWaitCompact", ds)).filter(stat -> stat == (long)expectedRemainingSegments).count();
                Assert.assertEquals((long)(i + 1), (long)numDataSourceOfExpectedRemainingSegments);
                continue;
            }
            Assert.assertEquals((long)(2 - i), (long)stats.getDataSources("segmentSizeWaitCompact").size());
        }
        for (i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            List holders = this.dataSources.get(dataSource).lookup(expectedInterval);
            Assert.assertEquals((long)1L, (long)holders.size());
            ArrayList chunks = Lists.newArrayList((Iterable)((TimelineObjectHolder)holders.get(0)).getObject());
            Assert.assertEquals((long)2L, (long)chunks.size());
            String expectedVersion = expectedVersionSupplier.get();
            for (PartitionChunk chunk : chunks) {
                Assert.assertEquals((Object)expectedInterval, (Object)((DataSegment)chunk.getObject()).getInterval());
                Assert.assertEquals((Object)expectedVersion, (Object)((DataSegment)chunk.getObject()).getVersion());
            }
        }
    }

    private void assertLastSegmentNotCompacted(DruidCoordinatorSegmentCompactor compactor) {
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            Interval interval = Intervals.of((String)StringUtils.format((String)"2017-01-09T12:00:00/2017-01-10", (Object[])new Object[0]));
            List holders = this.dataSources.get(dataSource).lookup(interval);
            Assert.assertEquals((long)1L, (long)holders.size());
            for (TimelineObjectHolder holder : holders) {
                ArrayList chunks = Lists.newArrayList((Iterable)holder.getObject());
                Assert.assertEquals((long)4L, (long)chunks.size());
                for (PartitionChunk chunk : chunks) {
                    DataSegment segment = (DataSegment)chunk.getObject();
                    Assert.assertEquals((Object)interval, (Object)segment.getInterval());
                    Assert.assertEquals((Object)"version", (Object)segment.getVersion());
                }
            }
        }
        String dataSource = "dataSource_0";
        this.addMoreData("dataSource_0", 9);
        CoordinatorStats stats = this.runCompactor(compactor);
        Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
        this.addMoreData("dataSource_0", 10);
        stats = this.runCompactor(compactor);
        Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
    }

    private void addMoreData(String dataSource, int day) {
        for (int i = 0; i < 2; ++i) {
            DataSegment newSegment = DruidCoordinatorSegmentCompactorTest.createSegment(dataSource, day, true, i);
            this.dataSources.get(dataSource).add(newSegment.getInterval(), (Object)newSegment.getVersion(), newSegment.getShardSpec().createChunk((Object)newSegment));
            newSegment = DruidCoordinatorSegmentCompactorTest.createSegment(dataSource, day, false, i);
            this.dataSources.get(dataSource).add(newSegment.getInterval(), (Object)newSegment.getVersion(), newSegment.getShardSpec().createChunk((Object)newSegment));
        }
    }

    private static List<DataSourceCompactionConfig> createCompactionConfigs() {
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            compactionConfigs.add(new DataSourceCompactionConfig(dataSource, Integer.valueOf(0), Long.valueOf(50L), null, new Period((Object)"PT1H"), null, null));
        }
        return compactionConfigs;
    }
}

