/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.cost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CachingCostBalancerStrategy;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CostBalancerStrategy;
import org.apache.hive.druid.org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.org.apache.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.org.apache.druid.server.coordinator.cost.ClusterCostCache;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingCostBalancerStrategyTest {
    private static final int DAYS_IN_MONTH = 30;
    private static final int SEGMENT_SIZE = 100;
    private static final int NUMBER_OF_SEGMENTS_ON_SERVER = 10000;
    private static final int NUMBER_OF_QUERIES = 1000;
    private static final int NUMBER_OF_SERVERS = 3;
    private List<ServerHolder> serverHolderList;
    private List<DataSegment> segmentQueries;
    private ListeningExecutorService executorService;

    @Before
    public void setUp() {
        Random random = new Random(0L);
        DateTime referenceTime = DateTimes.of((String)"2014-01-01T00:00:00");
        this.serverHolderList = IntStream.range(0, 3).mapToObj(i -> this.createServerHolder(String.valueOf(i), String.valueOf(i), 1100000, 10000, random, referenceTime)).collect(Collectors.toList());
        this.segmentQueries = this.createDataSegments(1000, random, referenceTime);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)""));
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void decisionTest() {
        CachingCostBalancerStrategy cachingCostBalancerStrategy = this.createCachingCostBalancerStrategy(this.serverHolderList, this.executorService);
        CostBalancerStrategy costBalancerStrategy = this.createCostBalancerStrategy(this.executorService);
        int notEqual = this.segmentQueries.stream().mapToInt(s -> {
            ServerHolder s1 = cachingCostBalancerStrategy.findNewSegmentHomeBalancer(s, this.serverHolderList);
            ServerHolder s2 = costBalancerStrategy.findNewSegmentHomeBalancer(s, this.serverHolderList);
            return s1.getServer().getName().equals(s2.getServer().getName()) ? 0 : 1;
        }).sum();
        Assert.assertTrue(((double)notEqual / (double)this.segmentQueries.size() < 0.01 ? 1 : 0) != 0);
    }

    private CachingCostBalancerStrategy createCachingCostBalancerStrategy(List<ServerHolder> serverHolders, ListeningExecutorService listeningExecutorService) {
        ClusterCostCache.Builder builder = ClusterCostCache.builder();
        serverHolders.forEach(s -> s.getServer().iterateAllSegments().forEach(segment -> builder.addSegment(s.getServer().getName(), segment)));
        return new CachingCostBalancerStrategy(builder.build(), listeningExecutorService);
    }

    private CostBalancerStrategy createCostBalancerStrategy(ListeningExecutorService listeningExecutorService) {
        return new CostBalancerStrategy(listeningExecutorService);
    }

    private ServerHolder createServerHolder(String name, String host, int maxSize, int numberOfSegments, Random random, DateTime referenceTime) {
        DruidServer druidServer = new DruidServer(name, host, null, (long)maxSize, ServerType.HISTORICAL, "normal", 0);
        this.createDataSegments(numberOfSegments, random, referenceTime).forEach(arg_0 -> ((DruidServer)druidServer).addDataSegment(arg_0));
        return new ServerHolder(druidServer.toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
    }

    private List<DataSegment> createDataSegments(int numberOfSegments, Random random, DateTime referenceTime) {
        return new ArrayList<DataSegment>(IntStream.range(0, numberOfSegments).mapToObj(i -> this.createRandomSegment(random, referenceTime)).collect(Collectors.toSet()));
    }

    private DataSegment createRandomSegment(Random random, DateTime referenceTime) {
        int timeShift = random.nextInt((int)TimeUnit.DAYS.toHours(360L));
        return new DataSegment(String.valueOf(random.nextInt(50)), new Interval((ReadableInstant)referenceTime.plusHours(timeShift), (ReadableInstant)referenceTime.plusHours(timeShift + 1)), "version", Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), null, Integer.valueOf(0), 100L);
    }
}

