/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.client.DataSourcesSnapshot;
import org.apache.hive.druid.org.apache.druid.client.DruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.org.apache.druid.client.ServerInventoryView;
import org.apache.hive.druid.org.apache.druid.client.SingleServerInventoryView;
import org.apache.hive.druid.org.apache.druid.common.config.JacksonConfigManager;
import org.apache.hive.druid.org.apache.druid.curator.CuratorTestBase;
import org.apache.hive.druid.org.apache.druid.curator.CuratorUtils;
import org.apache.hive.druid.org.apache.druid.curator.discovery.NoopServiceAnnouncer;
import org.apache.hive.druid.org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Event;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;
import org.apache.hive.druid.org.apache.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.hive.druid.org.apache.druid.server.coordinator.CuratorLoadQueuePeon;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.hive.druid.org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorTest
extends CuratorTestBase {
    private static final String LOADPATH = "/druid/loadqueue/localhost:1234";
    private static final long COORDINATOR_START_DELAY = 1L;
    private static final long COORDINATOR_PERIOD = 100L;
    private DruidCoordinator coordinator;
    private MetadataSegmentManager segmentsMetadata;
    private DataSourcesSnapshot dataSourcesSnapshot;
    private DruidCoordinatorRuntimeParams coordinatorRuntimeParams;
    private SingleServerInventoryView serverInventoryView;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    private DruidServer druidServer;
    private ConcurrentMap<String, LoadQueuePeon> loadManagementPeons;
    private LoadQueuePeon loadQueuePeon;
    private MetadataRuleManager metadataRuleManager;
    private CountDownLatch leaderAnnouncerLatch;
    private CountDownLatch leaderUnannouncerLatch;
    private PathChildrenCache pathChildrenCache;
    private DruidCoordinatorConfig druidCoordinatorConfig;
    private ObjectMapper objectMapper;
    private DruidNode druidNode;
    private LatchableServiceEmitter serviceEmitter = new LatchableServiceEmitter();

    @Before
    public void setUp() throws Exception {
        this.druidServer = (DruidServer)EasyMock.createMock(DruidServer.class);
        this.serverInventoryView = (SingleServerInventoryView)EasyMock.createMock(SingleServerInventoryView.class);
        this.segmentsMetadata = (MetadataSegmentManager)EasyMock.createNiceMock(MetadataSegmentManager.class);
        this.dataSourcesSnapshot = (DataSourcesSnapshot)EasyMock.createNiceMock(DataSourcesSnapshot.class);
        this.coordinatorRuntimeParams = (DruidCoordinatorRuntimeParams)EasyMock.createNiceMock(DruidCoordinatorRuntimeParams.class);
        this.metadataRuleManager = (MetadataRuleManager)EasyMock.createNiceMock(MetadataRuleManager.class);
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorCompactionConfig>(CoordinatorCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        this.setupServerAndCurator();
        this.curator.start();
        this.curator.blockUntilConnected();
        this.curator.create().creatingParentsIfNeeded().forPath(LOADPATH);
        this.objectMapper = new DefaultObjectMapper();
        this.druidCoordinatorConfig = new TestDruidCoordinatorConfig(new Duration(1L), new Duration(100L), null, null, new Duration(100L), null, 10, new Duration((Object)"PT0s"));
        this.pathChildrenCache = new PathChildrenCache(this.curator, LOADPATH, true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache-%d"));
        this.loadQueuePeon = new CuratorLoadQueuePeon(this.curator, LOADPATH, this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon-%d"), this.druidCoordinatorConfig);
        this.loadQueuePeon.start();
        this.druidNode = new DruidNode("hey", "what", false, Integer.valueOf(1234), null, true, false);
        this.loadManagementPeons = new ConcurrentHashMap<String, LoadQueuePeon>();
        this.scheduledExecutorFactory = new ScheduledExecutorFactory(){

            public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
                return Executors.newSingleThreadScheduledExecutor();
            }
        };
        this.leaderAnnouncerLatch = new CountDownLatch(1);
        this.leaderUnannouncerLatch = new CountDownLatch(1);
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, configManager, this.segmentsMetadata, (ServerInventoryView)this.serverInventoryView, this.metadataRuleManager, this.curator, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                DruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                DruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, null, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null);
    }

    @After
    public void tearDown() throws Exception {
        this.loadQueuePeon.stop();
        this.pathChildrenCache.close();
        this.tearDownServerAndCurator();
    }

    @Test
    public void testMoveSegment() {
        DataSegment segment = (DataSegment)EasyMock.createNiceMock(DataSegment.class);
        EasyMock.expect((Object)segment.getId()).andReturn((Object)SegmentId.dummy((String)"dummySegment"));
        EasyMock.expect((Object)segment.getDataSource()).andReturn((Object)"dummyDataSource");
        EasyMock.replay((Object[])new Object[]{segment});
        this.loadQueuePeon = (LoadQueuePeon)EasyMock.createNiceMock(LoadQueuePeon.class);
        EasyMock.expect((Object)this.loadQueuePeon.getLoadQueueSize()).andReturn((Object)new Long(1L));
        this.loadQueuePeon.markSegmentToDrop(segment);
        EasyMock.expectLastCall().once();
        Capture loadCallbackCapture = Capture.newInstance();
        Capture dropCallbackCapture = Capture.newInstance();
        this.loadQueuePeon.loadSegment((DataSegment)EasyMock.anyObject(DataSegment.class), (LoadPeonCallback)EasyMock.capture((Capture)loadCallbackCapture));
        EasyMock.expectLastCall().once();
        this.loadQueuePeon.dropSegment((DataSegment)EasyMock.anyObject(DataSegment.class), (LoadPeonCallback)EasyMock.capture((Capture)dropCallbackCapture));
        EasyMock.expectLastCall().once();
        this.loadQueuePeon.unmarkSegmentToDrop(segment);
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.loadQueuePeon.getSegmentsToDrop()).andReturn(new HashSet()).once();
        EasyMock.replay((Object[])new Object[]{this.loadQueuePeon});
        ImmutableDruidDataSource druidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)druidDataSource.getSegment((SegmentId)EasyMock.anyObject(SegmentId.class))).andReturn((Object)segment);
        EasyMock.replay((Object[])new Object[]{druidDataSource});
        EasyMock.expect((Object)this.segmentsMetadata.getImmutableDataSourceWithUsedSegments(EasyMock.anyString())).andReturn((Object)druidDataSource);
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadata});
        EasyMock.expect((Object)this.dataSourcesSnapshot.getDataSource(EasyMock.anyString())).andReturn((Object)druidDataSource).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.dataSourcesSnapshot});
        this.scheduledExecutorFactory = (ScheduledExecutorFactory)EasyMock.createNiceMock(ScheduledExecutorFactory.class);
        EasyMock.replay((Object[])new Object[]{this.scheduledExecutorFactory});
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        ImmutableDruidDataSource dataSource = (ImmutableDruidDataSource)EasyMock.createMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)dataSource.getSegments()).andReturn(Collections.singletonList(segment)).anyTimes();
        EasyMock.replay((Object[])new Object[]{dataSource});
        EasyMock.expect((Object)this.druidServer.toImmutableDruidServer()).andReturn((Object)new ImmutableDruidServer(new DruidServerMetadata("from", null, null, 5L, ServerType.HISTORICAL, null, 0), 1L, ImmutableMap.of((Object)"dummyDataSource", (Object)dataSource), 1)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.druidServer});
        DruidServer druidServer2 = (DruidServer)EasyMock.createMock(DruidServer.class);
        EasyMock.expect((Object)druidServer2.toImmutableDruidServer()).andReturn((Object)new ImmutableDruidServer(new DruidServerMetadata("to", null, null, 5L, ServerType.HISTORICAL, null, 0), 1L, ImmutableMap.of((Object)"dummyDataSource", (Object)dataSource), 1)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{druidServer2});
        this.loadManagementPeons.put("from", this.loadQueuePeon);
        this.loadManagementPeons.put("to", this.loadQueuePeon);
        EasyMock.expect((Object)this.serverInventoryView.isSegmentLoadedByServer("to", segment)).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView});
        this.mockCoordinatorRuntimeParams();
        this.coordinator.moveSegment(this.coordinatorRuntimeParams, this.druidServer.toImmutableDruidServer(), druidServer2.toImmutableDruidServer(), segment, null);
        LoadPeonCallback loadCallback = (LoadPeonCallback)loadCallbackCapture.getValue();
        loadCallback.execute();
        LoadPeonCallback dropCallback = (LoadPeonCallback)dropCallbackCapture.getValue();
        dropCallback.execute();
        EasyMock.verify((Object[])new Object[]{this.druidServer, druidServer2, this.loadQueuePeon, this.serverInventoryView, this.metadataRuleManager});
        EasyMock.verify((Object[])new Object[]{this.coordinatorRuntimeParams});
    }

    private void mockCoordinatorRuntimeParams() {
        EasyMock.expect((Object)this.coordinatorRuntimeParams.getDataSourcesSnapshot()).andReturn((Object)this.dataSourcesSnapshot).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinatorRuntimeParams});
    }

    @Test(timeout=60000L)
    public void testCoordinatorRun() throws Exception {
        String dataSource = "dataSource1";
        String tier = "hot";
        ForeverLoadRule foreverLoadRule = new ForeverLoadRule((Map)ImmutableMap.of((Object)tier, (Object)2));
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)foreverLoadRule)).atLeastOnce();
        EasyMock.expect((Object)this.metadataRuleManager.getAllRules()).andReturn((Object)ImmutableMap.of((Object)dataSource, (Object)ImmutableList.of((Object)foreverLoadRule))).atLeastOnce();
        this.metadataRuleManager.stop();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        DruidDataSource[] dataSources = new DruidDataSource[]{new DruidDataSource(dataSource, Collections.emptyMap())};
        final DataSegment dataSegment = new DataSegment(dataSource, Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        dataSources[0].addSegment(dataSegment);
        this.setupMetadataSegmentManagerMock(dataSources[0]);
        ImmutableDruidDataSource immutableDruidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)immutableDruidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)dataSegment)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{immutableDruidDataSource});
        this.druidServer = new DruidServer("server1", "localhost", null, 5L, ServerType.HISTORICAL, tier, 0);
        this.loadManagementPeons.put("server1", this.loadQueuePeon);
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.druidServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        Assert.assertTrue((boolean)this.coordinator.isLeader());
        Assert.assertEquals((Object)this.druidNode.getHostAndPort(), (Object)this.coordinator.getCurrentLeader());
        final CountDownLatch assignSegmentLatch = new CountDownLatch(1);
        this.pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent event) {
                if (CuratorUtils.isChildAdded((PathChildrenCacheEvent)event)) {
                    if (assignSegmentLatch.getCount() > 0L) {
                        DruidCoordinatorTest.this.druidServer.addDataSegment(dataSegment);
                        assignSegmentLatch.countDown();
                    } else {
                        Assert.fail((String)"The same segment is assigned to the same server multiple times");
                    }
                }
            }
        });
        this.pathChildrenCache.start();
        assignSegmentLatch.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)dataSource, (Object)100.0), (Object)this.coordinator.getLoadStatus());
        ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(ZKPaths.makePath((String)LOADPATH, (String)dataSegment.getId().toString()));
        Object2IntMap numsUnavailableUsedSegmentsPerDataSource = this.coordinator.computeNumsUnavailableUsedSegmentsPerDataSource();
        Assert.assertEquals((long)1L, (long)numsUnavailableUsedSegmentsPerDataSource.size());
        Assert.assertEquals((long)0L, (long)numsUnavailableUsedSegmentsPerDataSource.getInt((Object)dataSource));
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTier();
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)1L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSource = (Object2LongMap)underReplicationCountsPerDataSourcePerTier.get(tier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.size());
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource.get((Object)dataSource));
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.getLong((Object)dataSource));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        Assert.assertFalse((boolean)this.coordinator.isLeader());
        Assert.assertNull((Object)this.coordinator.getCurrentLeader());
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testCoordinatorTieredRun() throws Exception {
        String dataSource = "dataSource";
        String hotTierName = "hot";
        String coldTierName = "cold";
        IntervalLoadRule hotTier = new IntervalLoadRule(Intervals.of((String)"2018-01-01/P1M"), (Map)ImmutableMap.of((Object)"hot", (Object)1));
        ForeverLoadRule coldTier = new ForeverLoadRule((Map)ImmutableMap.of((Object)"cold", (Object)1));
        String loadPathCold = "/druid/loadqueue/cold:1234";
        DruidServer hotServer = new DruidServer("hot", "hot", null, 5L, ServerType.HISTORICAL, "hot", 0);
        DruidServer coldServer = new DruidServer("cold", "cold", null, 5L, ServerType.HISTORICAL, "cold", 0);
        ImmutableMap dataSegments = ImmutableMap.of((Object)"2018-01-02T00:00:00.000Z_2018-01-03T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-02/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2018-01-03T00:00:00.000Z_2018-01-04T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-03/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2017-01-01T00:00:00.000Z_2017-01-02T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2017-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L));
        CuratorLoadQueuePeon loadQueuePeonCold = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/cold:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_cold_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_cold-%d"), this.druidCoordinatorConfig);
        PathChildrenCache pathChildrenCacheCold = new PathChildrenCache(this.curator, "/druid/loadqueue/cold:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_cold-%d"));
        this.loadManagementPeons.putAll((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"hot", (Object)this.loadQueuePeon, (Object)"cold", (Object)loadQueuePeonCold));
        loadQueuePeonCold.start();
        this.pathChildrenCache.start();
        pathChildrenCacheCold.start();
        DruidDataSource[] druidDataSources = new DruidDataSource[]{new DruidDataSource("dataSource", Collections.emptyMap())};
        dataSegments.values().forEach(arg_0 -> ((DruidDataSource)druidDataSources[0]).addSegment(arg_0));
        this.setupMetadataSegmentManagerMock(druidDataSources[0]);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)hotTier, (Object)coldTier)).atLeastOnce();
        EasyMock.expect((Object)this.metadataRuleManager.getAllRules()).andReturn((Object)ImmutableMap.of((Object)"dataSource", (Object)ImmutableList.of((Object)hotTier, (Object)coldTier))).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)hotServer, (Object)coldServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager, this.serverInventoryView});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        CountDownLatch assignSegmentLatchHot = new CountDownLatch(2);
        this.pathChildrenCache.getListenable().addListener((arg_0, arg_1) -> this.lambda$testCoordinatorTieredRun$0((Map)dataSegments, hotServer, assignSegmentLatchHot, arg_0, arg_1));
        CountDownLatch assignSegmentLatchCold = new CountDownLatch(1);
        pathChildrenCacheCold.getListenable().addListener((arg_0, arg_1) -> this.lambda$testCoordinatorTieredRun$1((Map)dataSegments, coldServer, assignSegmentLatchCold, arg_0, arg_1));
        assignSegmentLatchHot.await();
        assignSegmentLatchCold.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"dataSource", (Object)100.0), (Object)this.coordinator.getLoadStatus());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTier();
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("cold")).getLong((Object)"dataSource"));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadata});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    private void setupMetadataSegmentManagerMock(DruidDataSource dataSource) {
        EasyMock.expect((Object)this.segmentsMetadata.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadata.iterateAllUsedSegments()).andReturn((Object)dataSource.getSegments()).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadata.getImmutableDataSourcesWithAllUsedSegments()).andReturn(Collections.singleton(dataSource.toImmutableDruidDataSource())).anyTimes();
        DataSourcesSnapshot dataSourcesSnapshot = new DataSourcesSnapshot((Map)ImmutableMap.of((Object)dataSource.getName(), (Object)dataSource.toImmutableDruidDataSource()));
        EasyMock.expect((Object)this.segmentsMetadata.getSnapshotOfDataSourcesWithAllUsedSegments()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadata.retrieveAllDataSourceNames()).andReturn(Collections.singleton(dataSource.getName())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadata});
        EasyMock.expect((Object)this.dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()).andReturn((Object)dataSource.getSegments()).anyTimes();
        EasyMock.expect((Object)this.dataSourcesSnapshot.getDataSourcesWithAllUsedSegments()).andReturn(Collections.singleton(dataSource.toImmutableDruidDataSource())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.dataSourcesSnapshot});
    }

    @Nullable
    private static DataSegment findSegmentRelatedToCuratorEvent(Map<String, DataSegment> dataSegments, PathChildrenCacheEvent event) {
        return dataSegments.entrySet().stream().filter(x -> event.getData().getPath().contains((CharSequence)x.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private /* synthetic */ void lambda$testCoordinatorTieredRun$1(Map dataSegments, DruidServer coldServer, CountDownLatch assignSegmentLatchCold, CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        if (CuratorUtils.isChildAdded((PathChildrenCacheEvent)event)) {
            DataSegment segment = DruidCoordinatorTest.findSegmentRelatedToCuratorEvent(dataSegments, event);
            if (segment != null) {
                coldServer.addDataSegment(segment);
                ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(event.getData().getPath());
            }
            assignSegmentLatchCold.countDown();
        }
    }

    private /* synthetic */ void lambda$testCoordinatorTieredRun$0(Map dataSegments, DruidServer hotServer, CountDownLatch assignSegmentLatchHot, CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        if (CuratorUtils.isChildAdded((PathChildrenCacheEvent)event)) {
            DataSegment segment = DruidCoordinatorTest.findSegmentRelatedToCuratorEvent(dataSegments, event);
            if (segment != null) {
                hotServer.addDataSegment(segment);
                ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(event.getData().getPath());
            }
            assignSegmentLatchHot.countDown();
        }
    }

    private static class LatchableServiceEmitter
    extends ServiceEmitter {
        private CountDownLatch latch;

        private LatchableServiceEmitter() {
            super("", "", null);
        }

        public void emit(Event event) {
            if (this.latch != null && "segment/count".equals(event.toMap().get("metric"))) {
                this.latch.countDown();
            }
        }
    }

    private static class TestDruidLeaderSelector
    implements DruidLeaderSelector {
        private volatile DruidLeaderSelector.Listener listener;
        private volatile String leader;

        private TestDruidLeaderSelector() {
        }

        public String getCurrentLeader() {
            return this.leader;
        }

        public boolean isLeader() {
            return this.leader != null;
        }

        public int localTerm() {
            return 0;
        }

        public void registerListener(DruidLeaderSelector.Listener listener) {
            this.listener = listener;
            this.leader = "what:1234";
            listener.becomeLeader();
        }

        public void unregisterListener() {
            this.leader = null;
            this.listener.stopBeingLeader();
        }
    }
}

