/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator;

import java.io.IOException;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.hive.druid.org.apache.druid.data.input.SplitHintSpec;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DataSourceCompactionConfigTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerdeBasic() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeWithMaxRowsPerSegment() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), Integer.valueOf(30), new Period(3600L), null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeUserCompactTuningConfig() throws IOException {
        DataSourceCompactionConfig.UserCompactTuningConfig config = new DataSourceCompactionConfig.UserCompactTuningConfig(null, null, null, null, null, null, null, null);
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        Assert.assertFalse((boolean)json.contains("maxRowsPerSegment"));
        DataSourceCompactionConfig.UserCompactTuningConfig fromJson = (DataSourceCompactionConfig.UserCompactTuningConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.UserCompactTuningConfig.class);
        Assert.assertEquals((Object)config, (Object)fromJson);
    }

    @Test
    public void testSerdeWithMaxTotalRows() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), new DataSourceCompactionConfig.UserCompactTuningConfig(null, null, Long.valueOf(10000L), null, null, null, null, null), (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeMaxTotalRowsWithMaxRowsPerSegment() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), Integer.valueOf(10000), new Period(3600L), new DataSourceCompactionConfig.UserCompactTuningConfig(null, null, Long.valueOf(10000L), null, null, null, null, null), (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeUserCompactionTuningConfig() throws IOException {
        DataSourceCompactionConfig.UserCompactTuningConfig tuningConfig = new DataSourceCompactionConfig.UserCompactTuningConfig(Integer.valueOf(1000), Long.valueOf(10000L), Long.valueOf(2000L), (SplitHintSpec)new SegmentsSplitHintSpec(Long.valueOf(10000L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(false)), CompressionStrategy.LZF, CompressionStrategy.UNCOMPRESSED, CompressionFactory.LongEncodingStrategy.LONGS), Integer.valueOf(1), Long.valueOf(3000L), null);
        String json = OBJECT_MAPPER.writeValueAsString((Object)tuningConfig);
        DataSourceCompactionConfig.UserCompactTuningConfig fromJson = (DataSourceCompactionConfig.UserCompactTuningConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.UserCompactTuningConfig.class);
        Assert.assertEquals((Object)tuningConfig, (Object)fromJson);
    }
}

