/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordination;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulator;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.hive.druid.org.apache.druid.client.cache.LocalCacheProvider;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.MapUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.query.ConcatQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.DefaultQueryMetrics;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.NoopQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryMetrics;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchResultValue;
import org.apache.hive.druid.org.apache.druid.segment.AbstractSegment;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.server.SegmentManager;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerManager;
import org.apache.hive.druid.org.apache.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerManagerTest {
    private ServerManager serverManager;
    private MyQueryRunnerFactory factory;
    private CountDownLatch queryWaitLatch;
    private CountDownLatch queryWaitYieldLatch;
    private CountDownLatch queryNotifyLatch;
    private ExecutorService serverManagerExec;
    private SegmentManager segmentManager;

    @Before
    public void setUp() {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.queryWaitLatch = new CountDownLatch(1);
        this.queryWaitYieldLatch = new CountDownLatch(1);
        this.queryNotifyLatch = new CountDownLatch(1);
        this.factory = new MyQueryRunnerFactory(this.queryWaitLatch, this.queryWaitYieldLatch, this.queryNotifyLatch);
        this.serverManagerExec = Executors.newFixedThreadPool(2);
        this.segmentManager = new SegmentManager(new SegmentLoader(){

            public boolean isSegmentLoaded(DataSegment segment) {
                return false;
            }

            public Segment getSegment(DataSegment segment, boolean lazy) {
                return new SegmentForTesting(MapUtils.getString((Map)segment.getLoadSpec(), (String)"version"), (Interval)segment.getLoadSpec().get("interval"));
            }

            public File getSegmentFiles(DataSegment segment) {
                throw new UnsupportedOperationException();
            }

            public void cleanup(DataSegment segment) {
            }
        });
        this.serverManager = new ServerManager(new QueryRunnerFactoryConglomerate(){

            public <T, QueryType extends Query<T>> QueryRunnerFactory<T, QueryType> findFactory(QueryType query) {
                return ServerManagerTest.this.factory;
            }
        }, (ServiceEmitter)new NoopServiceEmitter(), this.serverManagerExec, (CachePopulator)new ForegroundCachePopulator((ObjectMapper)new DefaultObjectMapper(), new CachePopulatorStats(), -1L), (ObjectMapper)new DefaultObjectMapper(), new LocalCacheProvider().get(), new CacheConfig(), this.segmentManager, new ServerConfig());
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-02"));
        this.loadQueryable("test", "2", Intervals.of((String)"P1d/2011-04-02"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-03"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-04"));
        this.loadQueryable("test", "1", Intervals.of((String)"P1d/2011-04-05"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T01"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T02"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T03"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T05"));
        this.loadQueryable("test", "2", Intervals.of((String)"PT1h/2011-04-04T06"));
        this.loadQueryable("test2", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.loadQueryable("test2", "1", Intervals.of((String)"P1d/2011-04-02"));
    }

    @Test
    public void testSimpleGet() {
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"P1d/2011-04-01"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)Intervals.of((String)"P1d/2011-04-01"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"P2d/2011-04-02"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)Intervals.of((String)"P1d/2011-04-01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"P1d/2011-04-02"))));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testDelete1() {
        String dataSouce = "test";
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Future future = this.assertQueryable(Granularities.DAY, "test", interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)interval)));
        this.waitForTestVerificationAndCleanup(future);
        this.dropQueryable("test", "2", interval);
        future = this.assertQueryable(Granularities.DAY, "test", interval, (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"1", (Object)interval)));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testDelete2() {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.waitForTestVerificationAndCleanup(future);
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        this.dropQueryable("test", "1", Intervals.of((String)"2011-04-04/2011-04-05"));
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04/2011-04-04T06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T00/2011-04-04T01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T01/2011-04-04T02")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T02/2011-04-04T03")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T04/2011-04-04T05")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T05/2011-04-04T06"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04/2011-04-04T03"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T00/2011-04-04T01")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T01/2011-04-04T02")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T02/2011-04-04T03"))));
        this.waitForTestVerificationAndCleanup(future);
        future = this.assertQueryable(Granularities.HOUR, "test", Intervals.of((String)"2011-04-04T04/2011-04-04T06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T04/2011-04-04T05")), (Object)new Pair((Object)"2", (Object)Intervals.of((String)"2011-04-04T05/2011-04-04T06"))));
        this.waitForTestVerificationAndCleanup(future);
    }

    @Test
    public void testReferenceCounting() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getSegmentReferences().size());
        for (ReferenceCountingSegment referenceCountingSegment : this.factory.getSegmentReferences()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.queryWaitYieldLatch.countDown();
        Assert.assertTrue((this.factory.getAdapters().size() == 1 ? 1 : 0) != 0);
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.queryWaitLatch.countDown();
        future.get();
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertTrue((boolean)segmentForTesting.isClosed());
        }
    }

    @Test
    public void testReferenceCountingWhileQueryExecuting() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getSegmentReferences().size());
        for (ReferenceCountingSegment referenceCountingSegment : this.factory.getSegmentReferences()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.queryWaitYieldLatch.countDown();
        Assert.assertEquals((long)1L, (long)this.factory.getAdapters().size());
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.queryWaitLatch.countDown();
        future.get();
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertTrue((boolean)segmentForTesting.isClosed());
        }
    }

    @Test
    public void testMultipleDrops() throws Exception {
        this.loadQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        Future future = this.assertQueryable(Granularities.DAY, "test", Intervals.of((String)"2011-04-04/2011-04-06"), (List<Pair<String, Interval>>)ImmutableList.of((Object)new Pair((Object)"3", (Object)Intervals.of((String)"2011-04-04/2011-04-05"))));
        this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.factory.getSegmentReferences().size());
        for (ReferenceCountingSegment referenceCountingSegment : this.factory.getSegmentReferences()) {
            Assert.assertEquals((long)1L, (long)referenceCountingSegment.getNumReferences());
        }
        this.queryWaitYieldLatch.countDown();
        Assert.assertEquals((long)1L, (long)this.factory.getAdapters().size());
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        this.dropQueryable("test", "3", Intervals.of((String)"2011-04-04/2011-04-05"));
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertFalse((boolean)segmentForTesting.isClosed());
        }
        this.queryWaitLatch.countDown();
        future.get();
        for (SegmentForTesting segmentForTesting : this.factory.getAdapters()) {
            Assert.assertTrue((boolean)segmentForTesting.isClosed());
        }
    }

    private void waitForTestVerificationAndCleanup(Future future) {
        try {
            this.queryNotifyLatch.await(1000L, TimeUnit.MILLISECONDS);
            this.queryWaitYieldLatch.countDown();
            this.queryWaitLatch.countDown();
            future.get();
            this.factory.clearAdapters();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Future assertQueryable(Granularity granularity, String dataSource, Interval interval, List<Pair<String, Interval>> expected) {
        final Iterator<Pair<String, Interval>> expectedIter = expected.iterator();
        List<Interval> intervals = Collections.singletonList(interval);
        final SearchQuery query = Druids.newSearchQueryBuilder().dataSource(dataSource).intervals(intervals).granularity(granularity).limit(10000).query("wow").build();
        final QueryRunner runner = this.serverManager.getQueryRunnerForIntervals((Query)query, intervals);
        return this.serverManagerExec.submit(new Runnable(){

            @Override
            public void run() {
                Sequence seq = runner.run(QueryPlus.wrap((Query)query));
                seq.toList();
                Iterator<SegmentForTesting> adaptersIter = ServerManagerTest.this.factory.getAdapters().iterator();
                while (expectedIter.hasNext() && adaptersIter.hasNext()) {
                    Pair expectedVals = (Pair)expectedIter.next();
                    SegmentForTesting value = adaptersIter.next();
                    Assert.assertEquals((Object)expectedVals.lhs, (Object)value.getVersion());
                    Assert.assertEquals((Object)expectedVals.rhs, (Object)value.getInterval());
                }
                Assert.assertFalse((boolean)expectedIter.hasNext());
                Assert.assertFalse((boolean)adaptersIter.hasNext());
            }
        });
    }

    public void loadQueryable(String dataSource, String version, Interval interval) {
        try {
            this.segmentManager.loadSegment(new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L), false);
        }
        catch (SegmentLoadingException e) {
            throw new RuntimeException(e);
        }
    }

    public void dropQueryable(String dataSource, String version, Interval interval) {
        this.segmentManager.dropSegment(new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L));
    }

    private static class BlockingSequence<T>
    extends YieldingSequenceBase<T> {
        private final Sequence<T> baseSequence;
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;

        private BlockingSequence(Sequence<T> baseSequence, CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.baseSequence = baseSequence;
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
            this.notifyLatch.countDown();
            try {
                this.waitYieldLatch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final Yielder baseYielder = this.baseSequence.toYielder(initValue, accumulator);
            return new Yielder<OutType>(){

                public OutType get() {
                    try {
                        waitLatch.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return baseYielder.get();
                }

                public Yielder<OutType> next(OutType initValue) {
                    return baseYielder.next(initValue);
                }

                public boolean isDone() {
                    return baseYielder.isDone();
                }

                public void close() throws IOException {
                    baseYielder.close();
                }
            };
        }
    }

    private static class BlockingQueryRunner<T>
    implements QueryRunner<T> {
        private final QueryRunner<T> runner;
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;

        public BlockingQueryRunner(QueryRunner<T> runner, CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.runner = runner;
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            return new BlockingSequence(this.runner.run(queryPlus, responseContext), this.waitLatch, this.waitYieldLatch, this.notifyLatch);
        }
    }

    private static class SegmentForTesting
    extends AbstractSegment {
        private final String version;
        private final Interval interval;
        private final Object lock = new Object();
        private volatile boolean closed = false;

        SegmentForTesting(String version, Interval interval) {
            this.version = version;
            this.interval = interval;
        }

        public String getVersion() {
            return this.version;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentId getId() {
            return SegmentId.dummy((String)this.version);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public Interval getDataInterval() {
            return this.interval;
        }

        public QueryableIndex asQueryableIndex() {
            throw new UnsupportedOperationException();
        }

        public StorageAdapter asStorageAdapter() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.closed = true;
            }
        }
    }

    public static class NoopQueryToolChest<T, QueryType extends Query<T>>
    extends QueryToolChest<T, QueryType> {
        public QueryRunner<T> mergeResults(QueryRunner<T> runner) {
            return runner;
        }

        public QueryMetrics<Query<?>> makeMetrics(QueryType query) {
            return new DefaultQueryMetrics();
        }

        public Function<T, T> makePreComputeManipulatorFn(QueryType query, MetricManipulationFn fn) {
            return Functions.identity();
        }

        public TypeReference<T> getResultTypeReference() {
            return new TypeReference<T>(){};
        }
    }

    public static class MyQueryRunnerFactory
    implements QueryRunnerFactory<Result<SearchResultValue>, SearchQuery> {
        private final CountDownLatch waitLatch;
        private final CountDownLatch waitYieldLatch;
        private final CountDownLatch notifyLatch;
        private List<SegmentForTesting> adapters = new ArrayList<SegmentForTesting>();
        private List<ReferenceCountingSegment> segmentReferences = new ArrayList<ReferenceCountingSegment>();

        public MyQueryRunnerFactory(CountDownLatch waitLatch, CountDownLatch waitYieldLatch, CountDownLatch notifyLatch) {
            this.waitLatch = waitLatch;
            this.waitYieldLatch = waitYieldLatch;
            this.notifyLatch = notifyLatch;
        }

        public QueryRunner<Result<SearchResultValue>> createRunner(Segment adapter) {
            if (!(adapter instanceof ReferenceCountingSegment)) {
                throw new IAE("Expected instance of ReferenceCountingSegment, got %s", new Object[]{adapter.getClass()});
            }
            ReferenceCountingSegment segment = (ReferenceCountingSegment)adapter;
            Assert.assertTrue((segment.getNumReferences() > 0 ? 1 : 0) != 0);
            this.segmentReferences.add(segment);
            this.adapters.add((SegmentForTesting)segment.getBaseSegment());
            return new BlockingQueryRunner<Result<SearchResultValue>>((QueryRunner<Result<SearchResultValue>>)new NoopQueryRunner(), this.waitLatch, this.waitYieldLatch, this.notifyLatch);
        }

        public QueryRunner<Result<SearchResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<SearchResultValue>>> queryRunners) {
            return new ConcatQueryRunner(Sequences.simple(queryRunners));
        }

        public QueryToolChest<Result<SearchResultValue>, SearchQuery> getToolchest() {
            return new NoopQueryToolChest<Result<SearchResultValue>, SearchQuery>();
        }

        public List<SegmentForTesting> getAdapters() {
            return this.adapters;
        }

        public List<ReferenceCountingSegment> getSegmentReferences() {
            return this.segmentReferences;
        }

        public void clearAdapters() {
            this.adapters.clear();
        }
    }
}

