/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordination;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.loading.CacheTestSegmentLoader;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.org.apache.druid.server.SegmentManager;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.hive.druid.org.apache.druid.server.coordination.ZkCoordinatorTest;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentLoadDropHandlerTest {
    public static final int COUNT = 50;
    private static final Logger log = new Logger(ZkCoordinatorTest.class);
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private SegmentLoadDropHandler segmentLoadDropHandler;
    private DataSegmentAnnouncer announcer;
    private File infoDir;
    private AtomicInteger announceCount;
    private ConcurrentSkipListSet<DataSegment> segmentsAnnouncedByMe;
    private CacheTestSegmentLoader segmentLoader;
    private SegmentManager segmentManager;
    private List<Runnable> scheduledRunnable;

    @Before
    public void setUp() {
        try {
            this.infoDir = new File(File.createTempFile("blah", "blah2").getParent(), "ZkCoordinatorTest");
            this.infoDir.mkdirs();
            for (File file : this.infoDir.listFiles()) {
                file.delete();
            }
            log.info("Creating tmp test files in [%s]", new Object[]{this.infoDir});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.scheduledRunnable = new ArrayList<Runnable>();
        this.segmentLoader = new CacheTestSegmentLoader();
        this.segmentManager = new SegmentManager((SegmentLoader)this.segmentLoader);
        this.segmentsAnnouncedByMe = new ConcurrentSkipListSet();
        this.announceCount = new AtomicInteger(0);
        this.announcer = new DataSegmentAnnouncer(){

            public void announceSegment(DataSegment segment) {
                SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.add(segment);
                SegmentLoadDropHandlerTest.this.announceCount.incrementAndGet();
            }

            public void unannounceSegment(DataSegment segment) {
                SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.remove(segment);
                SegmentLoadDropHandlerTest.this.announceCount.decrementAndGet();
            }

            public void announceSegments(Iterable<DataSegment> segments) {
                for (DataSegment segment : segments) {
                    SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.add(segment);
                }
                SegmentLoadDropHandlerTest.this.announceCount.addAndGet(Iterables.size(segments));
            }

            public void unannounceSegments(Iterable<DataSegment> segments) {
                for (DataSegment segment : segments) {
                    SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.remove(segment);
                }
                SegmentLoadDropHandlerTest.this.announceCount.addAndGet(-Iterables.size(segments));
            }
        };
        this.segmentLoadDropHandler = new SegmentLoadDropHandler(this.jsonMapper, new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentLoadDropHandlerTest.this.infoDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        }, this.announcer, (DataSegmentServerAnnouncer)EasyMock.createNiceMock(DataSegmentServerAnnouncer.class), this.segmentManager, new ScheduledExecutorFactory(){

            public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
                return new ScheduledThreadPoolExecutor(corePoolSize, Execs.makeThreadFactory((String)nameFormat)){

                    @Override
                    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                        SegmentLoadDropHandlerTest.this.scheduledRunnable.add(command);
                        return null;
                    }
                };
            }
        }.create(5, "SegmentLoadDropHandlerTest-[%d]"));
    }

    @Test
    public void testSegmentLoading1() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment = this.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.segmentLoadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)this.segmentLoader.getSegmentsInTrash().contains(segment));
        this.segmentLoadDropHandler.stop();
    }

    @Test
    public void testSegmentLoading2() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment = this.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)this.segmentLoader.getSegmentsInTrash().contains(segment));
        this.segmentLoadDropHandler.stop();
    }

    @Test
    public void testLoadCache() throws Exception {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-03")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-04")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-05")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T01")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T03")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T05")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T06")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        for (DataSegment segment : segments) {
            this.writeSegmentToCache(segment);
        }
        this.checkCache(segments);
        Assert.assertTrue((boolean)this.segmentManager.getDataSourceCounts().isEmpty());
        this.segmentLoadDropHandler.start();
        Assert.assertTrue((!this.segmentManager.getDataSourceCounts().isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)11L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((long)650L, (long)this.announceCount.get());
        this.segmentLoadDropHandler.stop();
        for (DataSegment segment : segments) {
            this.deleteSegmentFromCache(segment);
        }
        Assert.assertEquals((long)0L, (long)this.infoDir.listFiles().length);
        Assert.assertTrue((boolean)this.infoDir.delete());
    }

    private DataSegment makeSegment(String dataSource, String version, Interval interval) {
        return new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval, (Object)"cacheDir", (Object)this.infoDir), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L);
    }

    private void writeSegmentToCache(DataSegment segment) {
        if (!this.infoDir.exists()) {
            this.infoDir.mkdir();
        }
        File segmentInfoCacheFile = new File(this.infoDir, segment.getId().toString());
        try {
            this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)segmentInfoCacheFile.exists());
    }

    private void deleteSegmentFromCache(DataSegment segment) {
        File segmentInfoCacheFile = new File(this.infoDir, segment.getId().toString());
        if (segmentInfoCacheFile.exists()) {
            segmentInfoCacheFile.delete();
        }
        Assert.assertTrue((!segmentInfoCacheFile.exists() ? 1 : 0) != 0);
    }

    private void checkCache(Set<DataSegment> expectedSegments) {
        Assert.assertTrue((boolean)this.infoDir.exists());
        File[] files = this.infoDir.listFiles();
        Set segmentsInFiles = Arrays.stream(files).map(file -> {
            try {
                return (DataSegment)this.jsonMapper.readValue(file, DataSegment.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
        Assert.assertEquals(expectedSegments, segmentsInFiles);
    }

    @Test
    public void testStartStop() throws Exception {
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.jsonMapper, new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentLoadDropHandlerTest.this.infoDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }
        }, this.announcer, (DataSegmentServerAnnouncer)EasyMock.createNiceMock(DataSegmentServerAnnouncer.class), this.segmentManager);
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        for (DataSegment segment : segments) {
            this.writeSegmentToCache(segment);
        }
        this.checkCache(segments);
        Assert.assertTrue((boolean)this.segmentManager.getDataSourceCounts().isEmpty());
        handler.start();
        Assert.assertTrue((!this.segmentManager.getDataSourceCounts().isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)3L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((long)250L, (long)this.announceCount.get());
        handler.stop();
        for (DataSegment segment : segments) {
            this.deleteSegmentFromCache(segment);
        }
        Assert.assertEquals((long)0L, (long)this.infoDir.listFiles().length);
        Assert.assertTrue((boolean)this.infoDir.delete());
    }

    @Test(timeout=60000L)
    public void testProcessBatch() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment1 = this.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        DataSegment segment2 = this.makeSegment("batchtest2", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1), (Object)new SegmentChangeRequestDrop(segment2));
        ListenableFuture future = this.segmentLoadDropHandler.processBatch((List)batch);
        List result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.PENDING, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus());
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(1)).getStatus());
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)this.segmentLoadDropHandler.processBatch((List)batch).get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus());
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(1)).getStatus());
        for (SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus e : (List)this.segmentLoadDropHandler.processBatch((List)batch).get()) {
            Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)e.getStatus());
        }
        this.segmentLoadDropHandler.stop();
    }
}

