/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.audit;

import java.io.IOException;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.audit.AuditEntry;
import org.apache.hive.druid.org.apache.druid.audit.AuditInfo;
import org.apache.hive.druid.org.apache.druid.audit.AuditManager;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.org.apache.druid.server.audit.SQLAuditManager;
import org.apache.hive.druid.org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLAuditManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private AuditManager auditManager;
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.connector.createAuditTable();
        this.auditManager = new SQLAuditManager((SQLMetadataConnector)this.connector, this.derbyConnectorRule.metadataTablesConfigSupplier(), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig());
    }

    @Test(timeout=60000L)
    public void testAuditEntrySerde() throws IOException {
        AuditEntry entry = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        AuditEntry serde = (AuditEntry)mapper.readValue(mapper.writeValueAsString((Object)entry), AuditEntry.class);
        Assert.assertEquals((Object)entry, (Object)serde);
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntry() throws IOException {
        AuditEntry entry = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        this.auditManager.doAudit(entry);
        byte[] payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        AuditEntry dbEntry = (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
        Assert.assertEquals((Object)entry, (Object)dbEntry);
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistory() {
        AuditEntry entry = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        this.auditManager.doAudit(entry);
        this.auditManager.doAudit(entry);
        List auditEntries = this.auditManager.fetchAuditHistory("testKey", "testType", Intervals.of((String)"2012-01-01T00:00:00Z/2013-01-03T00:00:00Z"));
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry, auditEntries.get(0));
        Assert.assertEquals((Object)entry, auditEntries.get(1));
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistoryByKeyAndTypeWithLimit() {
        AuditEntry entry1 = new AuditEntry("testKey1", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        AuditEntry entry2 = new AuditEntry("testKey2", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-02T00:00:00Z"));
        this.auditManager.doAudit(entry1);
        this.auditManager.doAudit(entry2);
        List auditEntries = this.auditManager.fetchAuditHistory("testKey1", "testType", 1);
        Assert.assertEquals((long)1L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry1, auditEntries.get(0));
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistoryByTypeWithLimit() {
        AuditEntry entry1 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        AuditEntry entry2 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-02T00:00:00Z"));
        AuditEntry entry3 = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-03T00:00:00Z"));
        this.auditManager.doAudit(entry1);
        this.auditManager.doAudit(entry2);
        this.auditManager.doAudit(entry3);
        List auditEntries = this.auditManager.fetchAuditHistory("testType", 2);
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry3, auditEntries.get(0));
        Assert.assertEquals((Object)entry2, auditEntries.get(1));
    }

    @Test(expected=IllegalArgumentException.class, timeout=10000L)
    public void testFetchAuditHistoryLimitBelowZero() {
        this.auditManager.fetchAuditHistory("testType", -1);
    }

    @Test(expected=IllegalArgumentException.class, timeout=10000L)
    public void testFetchAuditHistoryLimitZero() {
        this.auditManager.fetchAuditHistory("testType", 0);
    }

    @After
    public void cleanup() {
        this.dropTable(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable());
    }

    private void dropTable(final String tableName) {
        Assert.assertNull((Object)this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
                return null;
            }
        }));
    }
}

